unit Main;

{
    Author  : Silicoid
    Date    : 08.03.2005
    Version : 1.0
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, StrUtils, TLKExport;

const
  VERSION_INFO = 'v1.0';

  TLK_SIGNATURE = 'TLK V3.0';

  TERM_LINE = '@';

  TYPE_EXP_ALL   = 0;
  TYPE_EXP_VIEW  = 1;
  TYPE_EXP_RANGE = 2;

  FLT_NO_CASE = 1;

type
  TMas = array of Integer;

  TSItem = class(TObject)
    unknow1: Integer;
    unknow2: Integer;
    unknow3: Integer;
    unknow4: Integer;
    unknow5: Integer;
    unknow6: Integer;
    unknow7: Integer;
    offset : Integer;
    strLen : Integer;
    unknow8: Integer;
    strText: String;
    //--- System ---
    num    : Integer;
    listNum: Integer;
  public
    constructor Create();
    destructor Free;
    procedure Clear();
    //------------------
    function  GetHeadSize(): Integer;
    function  ReadZeroStr(pFile: TFileStream): String;
    function  WriteZeroStr(pFile: TFileStream): Integer;
    function  GetSysStr(): String;
    procedure ReadFrom(pFile: TFileStream; dSeek: Integer);
    procedure WriteTo(pFile: TFileStream; dSeek: Integer);
    procedure ExportTo(pFile: TFileStream);
    procedure Translate(st: String);
    function  ReadText(pFile: TFileStream): Integer;
    procedure CopyFrom(itm: TSItem);
  end;

  TSList = class(TObject)
    sgnHead : array [1..8] of Char;
    unknow0 : Integer;
    stCount : Integer;
    stOffset: Integer;
    mas     : array of TSItem; 
  public
    constructor Create();
    destructor Free;
    procedure Clear();
    //------------------
    function  ReadFrom(pFile: TFileStream): Boolean;
    procedure WriteTo(pFile: TFileStream);
    procedure ExportTo(pFile: TFileStream; typExp: Integer);
    procedure ImportFrom(pFile: TFileStream);
    procedure Translate(st: String);
    procedure ReCalc();
    procedure FillListByFilter(lst: TListBox; sWord: String; attr: Integer; vFrom, vTo: Integer);
    procedure FillItemList(lst: TListBox; vFrom, vTo: Integer);
    function  GetTextByObj(itm: TSItem): String;
    procedure SetTextByObj(itm: TSItem; s: String);
    function  CheckFilter(sSub, sMain: String; attr: Integer): Boolean;
  end;

  TFrmMain = class(TForm)
    dlgOpenFile: TOpenDialog;
    grpCommand : TGroupBox;
    btnLoad    : TButton;
    stsInfo    : TStatusBar;
    prgInfo    : TProgressBar;
    pnlText    : TPanel;
    grpList    : TGroupBox;
    lstText    : TListBox;
    grpText    : TGroupBox;
    memText    : TMemo;
    splText    : TSplitter;
    btnSave    : TButton;
    dlgSaveFile: TSaveDialog;
    edtFilter  : TEdit;
    btnFilter  : TButton;
    chkCase    : TCheckBox;
    btnFind    : TButton;
    btnReplace : TButton;
    btnExport  : TButton;
    dlgExport  : TSaveDialog;
    btnImport  : TButton;
    dlgImport  : TOpenDialog;
    btnRefresh : TButton;
    chkAutoRef : TCheckBox;
    lblFrom    : TLabel;
    edtFrom    : TEdit;
    edtTo      : TEdit;
    lblTo      : TLabel;
    btnFull    : TButton;
    btnClear   : TButton;
    procedure btnLoadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lstTextClick(Sender: TObject);
    procedure memTextKeyPress(Sender: TObject; var Key: Char);
    procedure btnSaveClick(Sender: TObject);
    procedure btnFilterClick(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure memTextChange(Sender: TObject);
    procedure btnReplaceClick(Sender: TObject);
    procedure edtFilterChange(Sender: TObject);
    procedure btnExportClick(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnFullClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
  private
    lstObj: TSList;
  public
    procedure InitMain();
    procedure FreeMain();
    procedure StartLoad(sFile: String);
    procedure SaveNewFile(sFile: String);
    procedure ExportList(sFile: String; typExp: Integer);
    procedure ImportList(sFile: String);
    procedure GetEditTextByNum(num: Integer);
    procedure SetEditTextByNum(num: Integer);
    procedure ProcessFind(sFlt: String; attr: Integer);
    procedure ProcessFilter(sFlt: String; attr: Integer);
    procedure ProcessReplace(sFind, sRep: String; attr: Integer);
    procedure EnabledCritical(isEn: Boolean);
    procedure RefreshList();
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.dfm}

procedure Msg(s: String); overload;
begin
  Application.MessageBox(PChar(s), 'Debug', MB_OK); 
end;

procedure Msg(x: Integer); overload;
begin
  Msg(IntToStr(x));
end;

procedure ClearMemoGroup();
begin
  with FrmMain do
  begin
    memText.Clear;
    grpText.Caption:='';
  end;
end;

procedure SetItemGroupId(num: Integer);
begin
  FrmMain.grpText.Caption:=' (ID: ' + IntToStr(num) + ')';
end;

procedure GetRangeForm(var vFrom, vTo: Integer);
begin
  with FrmMain do
  begin
    vFrom:=StrToIntDef(edtFrom.Text,  0);
    vTo  :=StrToIntDef(edtTo.Text  , -1);
  end;
end;

procedure InitProgress(vMax: Integer);
begin
  with FrmMain do
  begin
    prgInfo.Position:=0; prgInfo.Max:=vMax;
  end;
  Application.ProcessMessages;
end;

procedure SetProgress(vCur: Integer; sText: String);
begin
  with FrmMain do
  begin
    if vCur<=prgInfo.Max then prgInfo.Position:=vCur;
    stsInfo.SimpleText:=sText;
  end;
  Application.ProcessMessages;
end;

function NormalizeStr(st: String): String;
var
  i: Integer;
  s: String;
begin
  s:='';
  for i:=1 to Length(st) do if st[i]=#10 then s:=s+#13#10 else s:=s+st[i];
  Result:=s;
end;

procedure SetCountGroup();
begin
  with FrmMain do
  begin
    stsInfo.SimpleText:=' : ' + IntToStr(lstText.Count) + ' / ' + IntToStr(Length(lstObj.mas));
  end;
end;

function ReadOneLine(pFile: TFileStream; var s: String): Integer;
var
  isEnd: Boolean;
  c: Char;
  k : Integer;
begin
  s:=''; isEnd:=false; k:=-1;
  while not isEnd and (k<>0) do
  begin
    k:=pFile.Read(c, 1);
    if k<>0 then
    begin
      if c<>#13 then
      begin
       s:=s+c
      end else
      begin
        pFile.Read(c, 1);
        if c<>#10 then pFile.Seek(pFile.Position-1, soFromBeginning);
        isEnd:=true;
      end;
    end;
  end;
  Result:=k;
end;

function GetSplitInteger(ps: Integer; st: String): TMas;
var
  arr: TMas;
  i, ln, k, v, z, u: Integer;
  s: String;
begin
  SetLength(arr, 0);
  i:=ps; ln:=Length(st); k:=-1;
  while (i<=ln) and (k<>0) do
  begin
    k:=PosEx(',',st,i);
    z:=k; if z=0 then z:=ln+1;
    s:=MidStr(st, i, z-i);
    v:=StrToIntDef(s, -1);
    //---------------------
    u:=Length(arr); SetLength(arr, u+1); arr[u]:=v;
    //---------------------
    i:=k+1;
  end;
  Result:=arr;
end;

function TrimEndOfLine(s: String): String;
var
  isEnd: Boolean;
  i, ln: Integer;
  st: String;
begin
  ln:=Length(s);
  i:=1; isEnd:=false;
  while (i<=ln) and not isEnd do
  begin
    if (s[i]=#13) or (s[i]=#10) or (s[i]=#9) then s[i]:=#0 else isEnd:=true;
    i:=i+1;
  end;
  //---------------------
  i:=ln; isEnd:=false;
  while (i>0) and not isEnd do
  begin
    if (s[i]=#13) or (s[i]=#10) or (s[i]=#9) then s[i]:=#0 else isEnd:=true;
    i:=i-1;
  end;
  //---------------------
  st:='';
  for i:=1 to ln do if (s[i]<>#0) and (s[i]<>#13) then st:=st+s[i];
  Result:=st;
end;

//============================================

constructor TSItem.Create();
begin
  Clear();
end;

destructor TSItem.Free;
begin
  Clear();
end;

procedure TSItem.Clear();
begin
  unknow1:=0;
  unknow2:=0;
  unknow3:=0;
  unknow4:=0;
  unknow5:=0;
  unknow6:=0;
  unknow7:=0;
  offset :=0;
  strLen :=0;
  unknow8:=0;
  strText:='';
  //--- System ---
  num    :=0;
  listNum:=0;
end;

function TSItem.GetHeadSize(): Integer;
begin
  Result:=40;
end;

function TSItem.ReadZeroStr(pFile: TFileStream): String;
var
  s: String;
  c: Byte;
begin
  s:='';
  repeat
    pFile.Read(c, 1); if c<>0 then s:=s+Chr(c);
  until c=0;
  Result:=s;
end;

function TSItem.WriteZeroStr(pFile: TFileStream): Integer;
var
  c: Byte;
  i: Integer;
begin
  for i:=1 to Length(strText) do pFile.Write(strText[i], 1);
  c:=0; pFile.Write(c, 1);
  Result:=pFile.Position;
end;

procedure TSItem.ReadFrom(pFile: TFileStream; dSeek: Integer);
var
  tSeek: Integer;
begin
  pFile.Read(unknow1, 4);
  pFile.Read(unknow2, 4);
  pFile.Read(unknow3, 4);
  pFile.Read(unknow4, 4);
  pFile.Read(unknow5, 4);
  pFile.Read(unknow6, 4);
  pFile.Read(unknow7, 4);
  pFile.Read(offset , 4);
  pFile.Read(strLen , 4);
  pFile.Read(unknow8, 4);
  tSeek:=pFile.Position;
  //---------------------
  pFile.Seek(dSeek+offset, soFromBeginning);
  strText:=TrimEndOfLine(ReadZeroStr(pFile));
  //---------------------
  pFile.Seek(tSeek, soFromBeginning);
end;

procedure TSItem.WriteTo(pFile: TFileStream; dSeek: Integer);
var
  tSeek: Integer;
begin
  pFile.Write(unknow1, 4);
  pFile.Write(unknow2, 4);
  pFile.Write(unknow3, 4);
  pFile.Write(unknow4, 4);
  pFile.Write(unknow5, 4);
  pFile.Write(unknow6, 4);
  pFile.Write(unknow7, 4);
  pFile.Write(offset , 4);
  pFile.Write(strLen , 4);
  pFile.Write(unknow8, 4);
  tSeek:=pFile.Position;
  //---------------------
  pFile.Seek(dSeek+offset, soFromBeginning);
  WriteZeroStr(pFile);
  //---------------------
  pFile.Seek(tSeek, soFromBeginning);
end;

function TSItem.GetSysStr(): String;
var
  s: String;
begin
  s:=TERM_LINE;
  s:=s+IntToStr(num)    +',';
  s:=s+IntToStr(unknow1)+',';
  s:=s+IntToStr(unknow2)+',';
  s:=s+IntToStr(unknow3)+',';
  s:=s+IntToStr(unknow4)+',';
  s:=s+IntToStr(unknow5)+',';
  s:=s+IntToStr(unknow6)+',';
  s:=s+IntToStr(unknow7)+',';
  s:=s+IntToStr(unknow8);
  Result:=s;
end;

procedure TSItem.ExportTo(pFile: TFileStream);
var
  i: Integer;  
  s: String;
begin
  s:=GetSysStr() + #13#10 + NormalizeStr(strText) + #13#10;
  for i:=1 to Length(s) do
  begin
    pFile.Write(s[i],1);
  end;
end;

procedure TSItem.Translate(st: String);
var
  arr: TMas;
  ln: Integer;
begin
  arr:=GetSplitInteger(2, st); ln:=Length(arr);
  if ln>0 then num    :=arr[0];
  if ln>1 then unknow1:=arr[1];
  if ln>2 then unknow2:=arr[2];
  if ln>3 then unknow3:=arr[3];
  if ln>4 then unknow4:=arr[4];
  if ln>5 then unknow5:=arr[5];
  if ln>6 then unknow6:=arr[6];
  if ln>7 then unknow7:=arr[7];
  if ln>8 then unknow8:=arr[8];
end;

function TSItem.ReadText(pFile: TFileStream): Integer;
var
  s: String;
  c: Char;
  k: Integer;
begin
  s:='';
  repeat
    k:=pFile.Read(c, 1);
    if c<>TERM_LINE then s:=s+c else pFile.Seek(pFile.Position-1, soFromBeginning);
  until (c=TERM_LINE) or (k=0);
  s:=TrimEndOfLine(s); strText:=s; strLen:=Length(strText)+1;
  Result:=k;
end;

procedure TSItem.CopyFrom(itm: TSItem);
begin
  unknow1:=itm.unknow1;
  unknow2:=itm.unknow2;
  unknow3:=itm.unknow3;
  unknow4:=itm.unknow4;
  unknow5:=itm.unknow5;
  unknow6:=itm.unknow6;
  unknow7:=itm.unknow7;
  offset :=itm.offset;
  strLen :=itm.strLen;
  unknow8:=itm.unknow8;
  strText:=itm.strText;
  //--- System ---
  num    :=itm.num;
end;

//------------------------------------

constructor TSList.Create();
begin
  Clear();
end;

destructor TSList.Free;
begin
  Clear();
end;

procedure TSList.Clear();
var
  i: Integer;
begin
  for i:=1 to 8 do sgnHead[i]:=#0;
  sgnHead:=TLK_SIGNATURE;
  unknow0 :=0;
  stCount :=0;
  stOffset:=0;
  for i:=0 to High(mas) do
  begin
    if mas[i]<>nil then mas[i].Free;
    mas[i]:=nil;
  end;
  SetLength(mas,0);
end;

function TSList.ReadFrom(pFile: TFileStream): Boolean;
var
  i: Integer;
  w: String;
begin
  Result:=false;
  pFile.Seek(0, soFromBeginning);
  for i:=1 to 8 do pFile.Read(sgnHead[i], 1);
  if sgnHead=TLK_SIGNATURE then
  begin
    pFile.Read(unknow0 , 4);
    pFile.Read(stCount , 4);
    pFile.Read(stOffset, 4);
    //--------------------------
    SetLength(mas, stCount);
    FrmMain.btnFull.OnClick(FrmMain.btnFull);
    InitProgress(stCount); w:=IntToStr(stCount);
    for i:=0 to stCount-1 do
    begin
      mas[i]:=TSItem.Create;
      mas[i].num:=i;
      mas[i].ReadFrom(pFile, stOffset);
      SetProgress(i, '  : ' + IntToStr(i+1) + ' / ' + w);
    end;
    InitProgress(0);
    Result:=true;
  end;
end;

procedure TSList.ReCalc();
begin
  stCount:=Length(mas);
  stOffset:=20 + stCount*40;
end;

procedure TSList.WriteTo(pFile: TFileStream);
var
  itm, empty: TSItem;
  i, dSeek, e: Integer;
  w: String;
begin
  ReCalc();
  pFile.Seek(0, soFromBeginning);
  for i:=1 to 8 do pFile.Write(sgnHead[i], 1);
  pFile.Write(unknow0 , 4);
  pFile.Write(stCount , 4);
  pFile.Write(stOffset, 4);
  //--------------------------
  empty:=TSItem.Create;
  try
    dSeek:=0; e:=0;
    InitProgress(stCount); w:=IntToStr(stCount);
    for i:=0 to High(mas) do
    begin
      itm:=mas[i];
      if itm=nil then
      begin
        itm:=empty; e:=e+1;
      end;
      itm.offset:=dSeek;
      itm.WriteTo(pFile, stOffset);
      dSeek:=dSeek+itm.strLen;
      SetProgress(i, '  : ' + IntToStr(i+1) + ' / ' + w + ' (: ' + IntToStr(e) + ')');
    end;
    InitProgress(0);
  finally
    empty.Free;
  end;
end;

procedure TSList.ExportTo(pFile: TFileStream; typExp: Integer);
var
  itm: TSItem;
  w: String;
  i, ln, iStart, iFin, e, k: Integer;
begin
  ReCalc();
  pFile.Seek(0, soFromBeginning);
  iStart:=0; e:=0; k:=0;
  if typExp = TYPE_EXP_ALL   then iFin:=High(mas);
  if typExp = TYPE_EXP_VIEW  then iFin:=FrmMain.lstText.Count-1;
  if typExp = TYPE_EXP_RANGE then GetRangeForm(iStart, iFin);
  ln:=iFin-iStart+1; InitProgress(ln); w:=IntToStr(iFin);
  for i:=iStart to iFin do
  begin
    if typExp = TYPE_EXP_VIEW then itm:=TSItem(FrmMain.lstText.Items.Objects[i]) else itm:=mas[i];
    if itm<>nil then
    begin
      itm.ExportTo(pFile); k:=k+1;
    end else
    begin
      e:=e+1;
    end;
    SetProgress(i, '  : ' + IntToStr(i+1) + ' / ' + w + ' (: ' + IntToStr(k) + ', : ' + IntToStr(e) + ')');
  end;
  InitProgress(0);
end;

procedure TSList.Translate(st: String);
var
  arr: TMas;
  ln: Integer;  
begin
  arr:=GetSplitInteger(2, st); ln:=Length(arr);
  if ln>0 then stCount:=arr[1];
  if ln>1 then unknow0:=arr[0];
end;

procedure TSList.ImportFrom(pFile: TFileStream);
var
  itm: TSItem;
  isEnd: Boolean;
  s: String;
  i, k, vMax: Integer;
begin
  pFile.Seek(0, soFromBeginning);
  InitProgress(pFile.Size);
  i:=0; k:=-1; vMax:=Length(mas);
  while (k<>0) do
  begin
    isEnd:=false;
    repeat
      k:=ReadOneLine(pFile, s);
      if Length(s)<>0 then if s[1]=TERM_LINE then isEnd:=true;
    until isEnd or (k=0);
    if k<>0 then
    begin
      itm:=TSItem.Create;
      itm.Translate(s);
      k:=itm.ReadText(pFile);
      if itm.num>=0 then
      begin
        if itm.num>=vMax then vMax:=itm.num+1;
        if itm.num>High(mas) then SetLength(mas, itm.num+1000);
        if mas[itm.num]<>nil then
        begin
          mas[itm.num].CopyFrom(itm);
          itm.Free;
        end else
        begin
          mas[itm.num]:=itm;
        end;
        i:=i+1;
      end;
    end;
    SetProgress(pFile.Position, ' : ' + IntToStr(i));
  end;
  SetLength(mas, vMax); ReCalc(); InitProgress(0);
  FrmMain.btnFull.OnClick(FrmMain.btnFull);
end;

procedure TSList.FillListByFilter(lst: TListBox; sWord: String; attr: Integer; vFrom, vTo: Integer);
var
  itm: TSItem;
  isFlt, isAdd: Boolean;
  i, ln, e, dif, k: Integer;
  w, v, z: String;
begin
  isFlt:=false; if Length(sWord)<>0 then isFlt:=true;
  if isFlt then z:='  : ' else z:='  : ';
  ln:=Length(mas); lst.Clear; v:=''; e:=0;
  if vTo<vFrom then begin vFrom:=0; vTo:=ln; end;
  i:=vFrom; dif:=vTo-vFrom+1;
  InitProgress(dif); w:=IntToStr(ln); k:=0;
  while (i<=vTo) and (i<ln) do
  begin
    itm:=mas[i]; v:=' (: ' + IntToStr(lst.Items.Count) + ', ';
    if itm<>nil then
    begin
      isAdd:=true;
      if isFlt then
      begin
        isAdd:=CheckFilter(sWord, itm.strText, attr);
        v:=' (: ' + IntToStr(lst.Count) + ', ';
      end;
      if isAdd then lst.Items.AddObject(itm.strText, itm);
    end else
    begin
      e:=e+1;
    end;
    i:=i+1; k:=k+1;
    SetProgress(k, z + IntToStr(i) + ' / ' + w + v + ': ' + IntToStr(e) + ')');
  end;
  InitProgress(0)
end;

procedure TSList.FillItemList(lst: TListBox; vFrom, vTo: Integer);
begin
  FillListByFilter(lst, '', 0, vFrom, vTo);
end;

function TSList.GetTextByObj(itm: TSItem): String;
begin
  Result:='';
  if itm<>nil then Result:=itm.strText;
end;

procedure TSList.SetTextByObj(itm: TSItem; s: String);
begin
  if itm<>nil then
  begin
    itm.strText:=s;
    itm.strLen:=Length(s)+1;
  end;
end;

function TSList.CheckFilter(sSub, sMain: String; attr: Integer): Boolean;
begin
  Result:=true;
  if (attr and FLT_NO_CASE)<>0 then
  begin
    sSub:=AnsiUpperCase(sSub); sMain:=AnsiUpperCase(sMain);
  end;
  if Pos(sSub, sMain)=0 then Result:=false;
end;

//==========================================================

procedure TFrmMain.StartLoad(sFile: String);
var
  vFrom, vTo: Integer;
  pFile: TFileStream;
begin
  if FileExists(sFile) then
  begin
    EnabledCritical(false);
    pFile:=TFileStream.Create(sFile, fmOpenRead);
    try
      ClearMemoGroup(); lstText.Clear(); lstObj.Clear;
      lstObj.ReadFrom(pFile);
      GetRangeForm(vFrom, vTo);
      if chkAutoRef.Checked then lstObj.FillItemList(lstText, vFrom, vTo);
    finally
      pFile.Free;
    end;
    EnabledCritical(true);
  end
  else Application.MessageBox(PChar('   [' + sFile + ']'), '', MB_OK);
end;

procedure TFrmMain.SaveNewFile(sFile: String);
var
  pFile: TFileStream;
begin
  pFile:=TFileStream.Create(sFile, fmCreate);
  try
    EnabledCritical(false);
    lstObj.WriteTo(pFile);
    EnabledCritical(true);
  finally
    pFile.Free;
  end;
end;

procedure TFrmMain.ExportList(sFile: String; typExp: Integer);
var
  pFile: TFileStream;
begin
  pFile:=TFileStream.Create(sFile, fmCreate);
  try
    EnabledCritical(false);
    lstObj.ExportTo(pFile, typExp);
    EnabledCritical(true);
  finally
    pFile.Free;
  end;
end;

procedure TFrmMain.ImportList(sFile: String);
var
  pFile: TFileStream;
  vFrom, vTo: Integer;
begin
  pFile:=TFileStream.Create(sFile, fmOpenRead);
  try
    EnabledCritical(false);
    lstObj.ImportFrom(pFile);
    if Length(lstObj.mas)<>0 then
    begin
      GetRangeForm(vFrom, vTo);
      if chkAutoRef.Checked then lstObj.FillItemList(lstText, vFrom, vTo);
      EnabledCritical(true);
    end else
    begin
      btnLoad.Enabled  :=true;
      btnImport.Enabled:=true;
    end;
  finally
    pFile.Free;
  end;
end;

procedure TFrmMain.GetEditTextByNum(num: Integer);
var
  itm: TSItem;
  s: String;
begin
  s:='';
  if (num>=0) and (num<lstText.Count) then
  begin
    itm:=TSItem(lstText.Items.Objects[num]);
    s:=lstObj.GetTextByObj(itm);
    SetItemGroupId(itm.num);
  end;
  memText.Lines.Text:=s;
end;

procedure TFrmMain.SetEditTextByNum(num: Integer);
var
  i: Integer;
  itm: TSItem;
  s: String;
begin
  if (num>=0) and (num<lstText.Count) then
  begin
    s:='';
    for i:=0 to memText.Lines.Count-1 do
    begin
      if Length(s)<>0 then s:=s+#10;
      s:=s+Trim(memText.Lines.Strings[i]);
    end;
    s:=TrimEndOfLine(s);
    itm:=TSItem(lstText.Items.Objects[num]);
    lstObj.SetTextByObj(itm, s);
    lstText.Items.Strings[num]:=s;
    SetItemGroupId(itm.num);
  end;
end;

procedure TFrmMain.ProcessFind(sFlt: String; attr: Integer);
var
  vFrom, vTo: Integer;
begin
  EnabledCritical(false);
  GetRangeForm(vFrom, vTo);
  lstObj.FillListByFilter(lstText, sFlt, attr, vFrom, vTo);
  EnabledCritical(true);
end;

procedure TFrmMain.ProcessFilter(sFlt: String; attr: Integer);
var
  itm: TSItem;
  isFlt, isAdd: Boolean;
  i, k: Integer;
begin
  EnabledCritical(false); InitProgress(lstText.Count);
  k:=0; isFlt:=false; if Length(sFlt)<>0 then isFlt:=true;
  for i:=lstText.Count-1 downto 0 do
  begin
    isAdd:=true; itm:=TSItem(lstText.Items.Objects[i]);
    if isFlt then isAdd:=lstObj.CheckFilter(sFlt, itm.strText, attr);
    if not isAdd then lstText.Items.Delete(i) else k:=k+1;
    SetProgress(i, '  : ' + IntToStr(i+1) + ' (: ' + IntToStr(k) + ')');
  end;
  ClearMemoGroup(); InitProgress(0); EnabledCritical(true);
end;

procedure TFrmMain.ProcessReplace(sFind, sRep: String; attr: Integer);
var
  flag: TReplaceFlags;
  itm: TSItem;
  i, k: Integer;
  s: String;
begin
  EnabledCritical(false); InitProgress(lstText.Count);
  k:=0; flag:=[rfReplaceAll];
  if (attr and FLT_NO_CASE)<>0 then flag:=flag + [rfIgnoreCase];
  for i:=0 to lstText.Count-1 do
  begin
    itm:=TSItem(lstText.Items.Objects[i]);
    s:=StringReplace(itm.strText, sFind, sRep, flag);
    if s<>itm.strText then
    begin
      itm.strText:=s; lstText.Items.Strings[i]:=s; k:=k+1;      
    end;
    SetProgress(i, '  : ' + IntToStr(i+1) + ' (: ' + IntToStr(k) + ')');
  end;
  GetEditTextByNum(lstText.ItemIndex);
  InitProgress(0); EnabledCritical(true);
end;

procedure TFrmMain.RefreshList();
var
  itm: TSItem;
  cnt, i: Integer;
begin
  ClearMemoGroup();
  cnt:=lstText.Count;
  InitProgress(cnt);
  for i:=0 to cnt-1 do
  begin
    itm:=TSItem(lstText.Items.Objects[i]);
    if itm<>nil then lstText.Items.Strings[i]:=itm.strText;
    SetProgress(i, '  : ' + IntToStr(i+1));
  end;
  lstTextClick(self);
  InitProgress(0); EnabledCritical(true);
end;

procedure TFrmMain.EnabledCritical(isEn: Boolean);
begin
  chkCase.Enabled   :=isEn;
  btnFind.Enabled   :=isEn;
  btnSave.Enabled   :=isEn;
  btnLoad.Enabled   :=isEn;
  btnExport.Enabled :=isEn;
  btnImport.Enabled :=isEn;
  btnClear.Enabled  :=isEn;
  btnRefresh.Enabled:=isEn;
  memText.ReadOnly  :=not isEn;
  edtFilter.ReadOnly:=not isEn;
  //----------------------------
  if isEn then isEn:=(Length(edtFilter.Text)<>0) and (lstText.Count<>0);
  btnFilter.Enabled :=isEn;
  btnReplace.Enabled:=isEn;
end;

procedure TFrmMain.InitMain();
begin
  self.Caption:='SWTLKEditor ' + VERSION_INFO;
  lstObj:=TSList.Create;
  prgInfo.DoubleBuffered:=true;
  stsInfo.DoubleBuffered:=true;
end;

procedure TFrmMain.FreeMain();
begin
  lstObj.Free;
end;

//==========================================================

procedure TFrmMain.FormCreate(Sender: TObject);
begin
  InitMain();
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
begin
  FreeMain();
end;

procedure TFrmMain.lstTextClick(Sender: TObject);
begin
  GetEditTextByNum(lstText.ItemIndex);
end;

procedure TFrmMain.memTextKeyPress(Sender: TObject; var Key: Char);
begin
  SetEditTextByNum(lstText.ItemIndex);
end;

procedure TFrmMain.btnLoadClick(Sender: TObject);
begin
  if dlgOpenFile.Execute then
  begin
    StartLoad(dlgOpenFile.FileName);
    Application.MessageBox('  ', '', MB_OK);
    SetCountGroup();
  end;
end;

procedure TFrmMain.btnSaveClick(Sender: TObject);
begin
  if dlgSaveFile.Execute then
  begin
    SaveNewFile(dlgSaveFile.FileName);
    Application.MessageBox('  ', '', MB_OK);
    SetCountGroup();
  end;
end;

procedure TFrmMain.btnFilterClick(Sender: TObject);
var
  attr: Integer;
begin
  attr:=0;
  if not chkCase.Checked then attr:=attr or FLT_NO_CASE;
  ClearMemoGroup();
  ProcessFilter(edtFilter.Text, attr);
  Application.MessageBox('  ', '', MB_OK);
  SetCountGroup();
end;

procedure TFrmMain.btnFindClick(Sender: TObject);
var
  attr: Integer;
begin
  attr:=0;
  if not chkCase.Checked then attr:=attr or FLT_NO_CASE;
  ClearMemoGroup();
  ProcessFind(edtFilter.Text, attr);
  Application.MessageBox('  ', '', MB_OK);
  SetCountGroup();
end;

procedure TFrmMain.memTextChange(Sender: TObject);
begin
  SetEditTextByNum(lstText.ItemIndex);
end;

procedure TFrmMain.btnReplaceClick(Sender: TObject);
var
  attr: Integer;
  p, v: String;
begin
  v:=edtFilter.Text;
  p:=' :' + #13#10 + v + #13#10 + '   :';
  if InputQuery('', p, v) then
  begin
    attr:=0;
    if not chkCase.Checked then attr:=attr or FLT_NO_CASE;
    ProcessReplace(edtFilter.Text, v, attr);
    Application.MessageBox('  ', '', MB_OK);
  end;
end;

procedure TFrmMain.edtFilterChange(Sender: TObject);
var
  isEn: Boolean;
begin
  isEn:=(Length(edtFilter.Text)<>0) and (lstText.Count<>0);
  btnFilter.Enabled :=isEn;
  btnReplace.Enabled:=isEn;
end;

procedure TFrmMain.btnExportClick(Sender: TObject);
var
  typExp: Integer;
begin
  if FrmExp.ShowModal = mrOK then
  begin
    typExp:=FrmExp.rdgExp.ItemIndex;
    if dlgExport.Execute then
    begin
      ExportList(dlgExport.FileName, typExp);
      Application.MessageBox('  ', '', MB_OK);
      SetCountGroup();
    end;
  end;
end;

procedure TFrmMain.btnImportClick(Sender: TObject);
begin
  if dlgImport.Execute then
  begin
    ImportList(dlgImport.FileName);
//    if not chkAutoRef.Checked then RefreshList();
    Application.MessageBox('  ', '', MB_OK);
    SetCountGroup();
  end;
end;

procedure TFrmMain.btnRefreshClick(Sender: TObject);
var
  vFrom, vTo: Integer;
begin
  GetRangeForm(vFrom, vTo);
  lstText.Clear; ClearMemoGroup();
  EnabledCritical(false);
  lstObj.FillItemList(lstText, vFrom, vTo);
  Application.MessageBox('!', '', MB_OK);
  EnabledCritical(true);
  SetCountGroup(); 
end;

procedure TFrmMain.btnFullClick(Sender: TObject);
var
  ln: Integer;
begin
  ln:=High(lstObj.mas);
  edtFrom.Text:='0'; edtTo.Text:=IntToStr(ln);
end;

procedure TFrmMain.btnClearClick(Sender: TObject);
var
  ret: Integer;
begin
  ret:=Application.MessageBox(' ,     ?', '', MB_YESNO);
  if ret=ID_YES then
  begin
    ClearMemoGroup(); lstText.Clear; lstObj.Clear;
    SetCountGroup(); btnFull.OnClick(btnFull);
  end;
end;

end.

