use strict;
use Bioware::GFF;
package main;
use Tk;
use Tk::Dialog;
use Win32::TieRegistry;
use Win32::FileOp;
our $version="1.0.3";
our $debug_flag;
our $x=1100;
our $y=600;
our $registered_path;
our @compare_widgets;
if (-e "KGC.log") {
    open STDERR, ">>", "KGC.log";
    $debug_flag=1;
}
LogIt ('***KotOR Global Comparison startup '.$version);


#-------------- MAIN WINDOW INVOCATION ------------------
our $mw=MainWindow->new(-title=>'KotOR Global Variable Comparision Tool',-relief=>'groove');
$mw->geometry($x."x$y");
my $icon;

#-------------- VERSION LABEL ---------------------------
$mw->Label(-text=>$version)->place(-relx=>900/$x,-rely=>590/$y,-anchor=>'se');                  #create version label

#-------------- LISTBOXES -------------------------------
    use Tk::BrowseEntry;
my $list1var;
my $list2var;
our $list1= $mw->BrowseEntry(-label=>'Select savegame #1',
                      #-background=>'white',
                      #-listheight=>500,
                      #-autolimitheight=>1,
                      -state=>'readonly',
                      -variable=>\$list1var,
                      )->place(-relx=>(10/$x),-rely=>(60/$y),-relwidth=>(400/$x),-relheight=>(20/$y));
my $entry1=$list1->Subwidget('entry')->Subwidget('entry');
our $list2= $mw->BrowseEntry(-label=>'Select savegame #2',
                      #-background=>'white',
                      #-listheight=>500,
                      #-autolimitheight=>1,
                      -state=>'readonly',
                      -variable=>\$list2var,
                      )->place(-relx=>10/$x,-rely=>100/$y,-relwidth=>400/$x,-relheight=>20/$y);
my $entry2=$list2->Subwidget('entry')->Subwidget('entry');
unless ($Tk::VERSION  eq '800.024') {
    $list1->configure(-listheight=>500);
    $list1->configure(-autolimitheight=>1);
    $list2->configure(-listheight=>500);
    $list2->configure(-autolimitheight=>1);
    $entry1->configure(-disabledbackground=>'white');
    $entry1->configure(-disabledforeground=>'black');
    $entry2->configure(-disabledbackground=>'white');
    $entry2->configure(-disabledforeground=>'black');
}

#-------------- LISTBOX CAPTIONS -----------------------
$mw->Label(-text=>'Select one savegame from each list to perform a GLOBAL VARIABLE comparison')->place(-relx=>10/$x,-rely=>50/$y,-anchor=>'sw');

#-------------- COMPARE BUTTON -------------------------
sub compare_globals;
sub output_data;
sub save_as_dialog;
our $btn= $mw->Button(-text=>"Compare ->",
                      -command=>\&compare_globals
                     )->place(-relx=>400/$x,-rely=>160/$y,-relwidth=>120/$x,-anchor=>'ne');


#-------------- ICON ----------------
eval {
    my $iconfile="c3po.bmp";
    $icon=PerlApp::extract_bound_file($iconfile);
};              #Extract .bmp from .exe
unless ($@) {
    my $image = $mw->Photo(-file => $icon, -format => 'bmp');                                   #apply .bmp as application icon
    $mw->Icon(-image => $image);
}
#------------- KOTOR PATH ---------------
my $choice = $mw->Dialog(-title=>'Choose KotOR or TSL',-text=>'Which game version do you wish to use?',-buttons=>['KotOR','KotOR2'])->Show();
if ($choice eq 'KotOR') {
eval { my  $kotor_key= new Win32::TieRegistry "LMachine/Software/Bioware/SW/Kotor",             #read registry
          {Access=>Win32::TieRegistry::KEY_READ, Delimiter=>"/"};
        $registered_path= $kotor_key->GetValue("Path") };
} else  {
eval { my  $kotor_key= new Win32::TieRegistry "LMachine/Software/LucasArts/Kotor2",             #read registry
          {Access=>Win32::TieRegistry::KEY_READ, Delimiter=>"/"};
        $registered_path= $kotor_key->GetValue("Path") };
}
if ($@) {                                                                                       #or tell user to browse for it
    unless ($registered_path=BrowseForFolder('Locate '.$choice.' installation directory')){exit;}}
unless (opendir SAVDIR, $registered_path."/saves") {                                            #saves directory not found
    $mw->messageBox(-title=>'Directory not found',
                    -message=>'Could not find saves directory in installation path',-type=>'Ok');
    LogIt ('KSE could not find saves directory. Exiting.');
    exit;
}
LogIt ('KSE found saves directory in ' . $registered_path);
my @savedirs=grep { !(/\\\.+$/) && -d } map {"$registered_path\\saves\\$_"} readdir(SAVDIR);    #read all directories in saves dir
close SAVDIR;
for (@savedirs) {
    my $fullpath=$_;
    /\\.*\\(.+?)$/;
    my $dir=$1;
    my $sgn=get_savegame_name($fullpath);
    $list1->insert('end',$dir. " ( $sgn )");
    $list2->insert('end',$dir. " ( $sgn )");

}

MainLoop;

#-------------- END ----------------------
LogIt ("---------Termination---------");
close STDERR;

sub get_savegame_name {
    my $dir=shift;
    my $file_to_open="$dir\\savenfo.res";
    LogIt ("Reading savenfo file: $file_to_open");
    my $gff=Bioware::GFF->new();
    $gff->read_gff_file("$dir\\savenfo.res");
    my $savegamename=$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('SAVEGAMENAME')]{'Value'};
    return $savegamename;
}

sub compare_globals {
    for my $widge (@compare_widgets) {   #unspawn old widgets
        $widge->destroy if Tk::Exists($widge);
    }
    @compare_widgets=();
    my $list1_index=$list1var;
    my $list2_index=$list2var;
    return if ( ($list1_index eq '') or ($list2_index eq ''));
    my $list1_element=$list1var;
    my $list2_element=$list2var;
    my $gff1=Bioware::GFF->new();
    my $gff2=Bioware::GFF->new();
    $list1_element =~ /(.+) \(/;
    my $list1_file="$registered_path\\saves\\$1\\GLOBALVARS.res";
    $gff1->read_gff_file($list1_file);
    $list2_element =~ /(.+) \(/;
    my $list2_file="$registered_path\\saves\\$1\\GLOBALVARS.res";
    $gff2->read_gff_file($list2_file);

    #-------- Create Boolean List -------
    my $bool_list=$mw->Scrolled('Listbox',
                      -scrollbars=>'osoe',
                      -background=>'white',
                      -selectborderwidth=>'0',
                      -selectforeground=>'#FFFFFF',
                      -selectbackground=>'#0000A0',
                      -selectmode=>'single',
                      -exportselection=>0
                      )->place(-relx=>(430/$x),-rely=>(50/$y),-relwidth=>(200/$x),-relheight=>(500/$y));
    push @compare_widgets,$bool_list;
    #-------- Boolean caption -----------
    my $lbl1=$mw->Label(-text=>"Boolean Differences")->place(-relx=>510/$x,-rely=>50/$y,-anchor=>'sw');

    #-------- Compare Booleans ----------
    my $catboolean_ix1=$gff1->{Main}->get_field_ix_by_label('CatBoolean');
    my $catboolean_ix2=$gff2->{Main}->get_field_ix_by_label('CatBoolean');
    my $valboolean_ix1=$gff1->{Main}->get_field_ix_by_label('ValBoolean');
    my $valboolean_ix2=$gff2->{Main}->get_field_ix_by_label('ValBoolean');
    my $bitstring1=unpack('B*',$gff1->{Main}{'Fields'}[$valboolean_ix1]{'Value'});
    my $bitstring2=unpack('B*',$gff2->{Main}{'Fields'}[$valboolean_ix2]{'Value'});
    my @bits1=split //,$bitstring1;
    my @bits2=split //,$bitstring2;
    my %bool1;
    for (my $i=0; $i< scalar @{$gff1->{Main}{Fields}[$catboolean_ix1]{'Value'}}; $i++) {
        my $kee=$gff1->{Main}{Fields}[$catboolean_ix1]{'Value'}[$i]{'Fields'}{'Value'};
        $bool1{$kee}=$bits1[$i];
    }
    my @delta_b;
    for (my $i=0; $i< scalar @{$gff2->{Main}{Fields}[$catboolean_ix2]{'Value'}}; $i++) {
        my $kee=$gff2->{Main}{Fields}[$catboolean_ix2]{'Value'}[$i]{'Fields'}{'Value'};
        if ($bool1{$kee} != $bits2[$i]) {
            push @delta_b,"$kee $bool1{$kee} -> $bits2[$i]";
        }
    }
    @delta_b = sort @delta_b;
    $bool_list->insert(0,@delta_b);
    unless ($bool_list->size()) { $bool_list ->insert(0,'<no differences>'); }
    #-------- Create Numeric List -------
    my $num_list=$mw->Scrolled('Listbox',
                      -scrollbars=>'osoe',
                      -background=>'white',
                      -selectborderwidth=>'0',
                      -selectforeground=>'#FFFFFF',
                      -selectbackground=>'#0000A0',
                      -selectmode=>'single',
                      -exportselection=>0
                      )->place(-relx=>(640/$x),-rely=>(50/$y),-relwidth=>(200/$x),-relheight=>(500/$y));
    push @compare_widgets,$num_list;
    #-------- Numeric caption -----------
    my $lbl2=$mw->Label(-text=>"Numeric Differences")->place(-relx=>720/$x,-rely=>50/$y,-anchor=>'sw');


    my %num1;
    my $cat_number_ix1=$gff1->{Main}->get_field_ix_by_label('CatNumber');
    my $valnumber_ix1=$gff1->{Main}->get_field_ix_by_label('ValNumber');
    my $cat_number_ix2=$gff2->{Main}->get_field_ix_by_label('CatNumber');
    my $valnumber_ix2=$gff2->{Main}->get_field_ix_by_label('ValNumber');
    my $numbers_to_unpack=scalar @{$gff1->{Main}{'Fields'}[$cat_number_ix1]{Value}};

    my @byts1=unpack('C'.$numbers_to_unpack,$gff1->{Main}{'Fields'}[$valnumber_ix1]{'Value'});
    my @byts2=unpack('C'.$numbers_to_unpack,$gff2->{Main}{'Fields'}[$valnumber_ix2]{'Value'});

    for (my $i=0; $i< scalar @{$gff1->{Main}{Fields}[$cat_number_ix1]{'Value'}}; $i++) {
        my $kee=$gff1->{Main}{Fields}[$cat_number_ix1]{'Value'}[$i]{'Fields'}{'Value'};
        $num1{$kee}=$byts1[$i];
    }
    my @delta_n;
    for (my $i=0; $i< scalar @{$gff2->{Main}{Fields}[$cat_number_ix2]{'Value'}}; $i++) {
        my $kee=$gff2->{Main}{Fields}[$cat_number_ix2]{'Value'}[$i]{'Fields'}{'Value'};
        if ($num1{$kee} != $byts2[$i]) {
            push @delta_n,"$kee $num1{$kee} -> $byts2[$i]";
        }
    }
    @delta_n=sort @delta_n;
    $num_list->insert(0,@delta_n);
    unless ($num_list->size()) { $num_list ->insert(0,'<no differences>'); }

    #-------- Create String List -------
    my $str_list=$mw->Scrolled('Listbox',
                      -scrollbars=>'osoe',
                      -background=>'white',
                      -selectborderwidth=>'0',
                      -selectforeground=>'#FFFFFF',
                      -selectbackground=>'#0000A0',
                      -selectmode=>'single',
                      -exportselection=>0
                      )->place(-relx=>(850/$x),-rely=>(50/$y),-relwidth=>(200/$x),-relheight=>(500/$y));
    push @compare_widgets,$str_list;
    #-------- Numeric caption -----------
    my $lbl3=$mw->Label(-text=>"String Differences")->place(-relx=>930/$x,-rely=>50/$y,-anchor=>'sw');

    my $catstring_ix1=$gff1->{Main}->get_field_ix_by_label('CatString');
    my $valstring_ix1=$gff1->{Main}->get_field_ix_by_label('ValString');
    my $catstring_ix2=$gff2->{Main}->get_field_ix_by_label('CatString');
    my $valstring_ix2=$gff2->{Main}->get_field_ix_by_label('ValString');
    my %str1;
    for (my $i=0; $i< scalar @{$gff1->{Main}{Fields}[$catstring_ix1]{'Value'}}; $i++) {
        my $kee=$gff1->{Main}{Fields}[$catstring_ix1]{'Value'}[$i]{'Fields'}{'Value'};
        $str1{$kee}=$gff1->{Main}{Fields}[$valstring_ix1]{'Value'}[$i]{'Fields'}{'Value'};
    }
    my @delta_s;
    for (my $i=0; $i< scalar @{$gff2->{Main}{Fields}[$catstring_ix2]{'Value'}}; $i++) {
        my $kee=$gff2->{Main}{Fields}[$catstring_ix2]{'Value'}[$i]{'Fields'}{'Value'};
        if ($str1{$kee} ne $gff2->{Main}{Fields}[$valstring_ix1]{'Value'}[$i]{'Fields'}{'Value'}) {
            push @delta_s,"$kee '" .$str1{$kee}."' -> '". $gff2->{Main}{Fields}[$valstring_ix1]{'Value'}[$i]{'Fields'}{'Value'}."'";
        }
    }
    @delta_s=sort @delta_s;
    $str_list->insert(0,@delta_s);
    unless ($str_list->size()) { $str_list ->insert(0,'<no differences>'); }


        my $btn2= $mw->Button(-text=>"Save to file",
                      -command=>sub {save_as_dialog(\$bool_list,\$num_list,\$str_list)}
                    )->place(-relx=>400/$x,-rely=>200/$y,-relwidth=>120/$x,-anchor=>'ne');
        
    push @compare_widgets,$btn2;

}
sub LogIt {
    unless ($debug_flag) {return;}
    my $loginfo=shift;
    my ($sec,$min,$hour,$mday,$mon,$year)=localtime;
    printf STDERR "%.2u-%.2u-%.4u %.2u:%.2u:%.2u %s\n",($mon+1,$mday,$year+1900,$hour,$min,$sec,$loginfo);
    return;
}

sub save_as_dialog{ #save as dialog box
    my ($bool_listref, $num_listref, $str_listref)=@_;
    my $outputfile='GVC_out.txt';
    my %parms=(
                title => "Save Output File As", handle=>0,
                filters => { 'Text file' => '*.txt', 'All Files' => '*.*'},
                filename=>$outputfile,
                options =>  OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT);
    $outputfile = SaveAsDialog \%parms;
    if ($outputfile) {output_data($outputfile,$bool_listref,$num_listref,$str_listref)}
}
sub output_data{
   my ($outputfile,$bool_listref,$num_listref,$str_listref)=@_;

   open T, ">", $outputfile or die "Could open $outputfile for writing $!\n";
   print T "Global Variable Comparison $version\n";
   print T "----------------------------------------\n";
   print T "File 1: $list1var\n";
   print T "File 2: $list2var\n";
   print T "----------------------------------------\n";
   print T "\n";
   print T "Boolean Comparisons\n";
   print T "----------------------------------------\n";
   my $bool_list=$$bool_listref;
   my @bool_items=$bool_list->get(0,'end');
   while (@bool_items) {$_=shift @bool_items; print T "$_\n";}
   print T "\n";
   print T "Numeric Comparisons\n";
   print T "----------------------------------------\n";
   my $num_list=$$num_listref;
   my @num_items=$num_list->get(0,'end');
   while (@num_items) {$_=shift @num_items; print T "$_\n";}
   print T "\n";
   print T "String Comparisons\n";
   print T "----------------------------------------\n";
   my $str_list=$$str_listref;
   my @str_items=$str_list->get(0,'end');
   while (@str_items) {$_=shift @str_items; print T "$_\n";}
   close T;
   $mw->Dialog(-title=>"File Saved",-text=>"File saved",-buttons=>['OK'])->Show();
}