# How to set top level icon
##################################
#  note: you must set the following option in PerlApp manually (do not use "Add Files" section, doesn't work)
#    --bind <filename as denoted by extract_bound_file>[file=<original filename/path on hard drive>]
#
#  Then in the file, use extract_bound_file to extract the file into temp dir and return temp file name
#  Finally, apply this to icon by creating a photo widget from tempfile and passing it to the toplevel icon method
# example:
#    c:\perl\bin\perlapp.exe --script test.pl --exe test.exe --gui --bind 1.bmp[file=c:\1.bmp]
# where test.pl is:
#    my $datafile="1.bmp";
#    my $filename=PerlApp::extract_bound_file($datafile);
#    use Tk;
#    my $mw=MainWindow->new();
#    $mw->title("Hello World");
#    $mw->Button(-text => "Done", -command => sub {exit})->pack;
#    my $image = $mw->Photo(-file => $filename, -format => 'bmp');
#    $mw->Icon(-image => $image);
#    MainLoop;
###########################3\


# v2.0.0 6/15/04 Complete re-write to make use of new GFF/ERF functions
#                added appearance and name change for NPC
# v2.0.1 6/17/04 Added Inventory widgets
# v2.0.2 6/17/04 Added Portraits for NPC, changed Inventory list to TList
#                  read items from override
# v2.0.3 6/17/04 Added ability to read from override appearance/portraits
# v2.0.4 6/17/04 Updated TwoDA module to not return blank, fixed bugs with
#                 position, orientation in inventory editing
# v2.0.5 6/19/04 Fixed bugs regarding BodyVariation, TextureVar in inventory editing
# v2.0.6 6/21/04 Added error handling (Tk::Error) and fixed AREANAME bug
# v2.0.7 6/23/04 Changed handling of "KSE alternate" now dependent on Perl/Tk install version
#                also made handling of custom .uti files more robust (use of $lilhash variable)
# v2.0.8 8/12/04 (by Darth333) added Soundset file manipulation capability

# v2.1.0 9/1/04  Added Inventory Copy/Paste popup menu
# v2.1.1 9/1/04  Added ability to right click inventory node as well
use strict;
use Bioware::GFF 0.61;
use Bioware::TwoDA 0.02;
use Bioware::ERF 0.11;
use Bioware::TLK;
use Bioware::BIF 0.02;

package main;


$SIG{ALRM}='IGNORE';  #no SIGALARM!!!  v1.4.2




our $x=900;
our $y=600;

our $bandaid=0;
sub What;
sub RWhat;
sub WhatNow;
sub LogIt;
sub Populate_Level1;
sub Populate_Skills;
sub Populate_Feats;
sub Populate_Classes;
sub ReadSavenfoRes;
sub ReadPartyTable;
sub ReadSaveGame;

use Tk;
use Tk::Tree;
use Tk::TList;
use Tk::ItemStyle;
#use Tk::ErrorDialog;
require Tk::Dialog;
our $version='v2.1.1';
if ($Tk::VERSION  eq '800.024') { $version .= ' alternate'}
use Win32::FileOp;
use Win32::TieRegistry;
use bytes;
our %leaf_memory;

our %classes= qw(
0  Soldier     1  Scout       2  Scoundrel   3  JediGuardian 4  JediConsular 5  JediSentinel
6  CombatDroid 7  ExpertDroid 8  Minion      );
our %feats_short = qw (                     1    ADVANCED_JEDI_DEFENSE
3    TWO_WEAPON_FIGHTING              4    ARMOUR_PROF_HEAVY                5    ARMOUR_PROF_LIGHT
6    ARMOUR_PROF_MEDIUM               7    CAUTIOUS                         8    CRITICAL_STRIKE
9    TWO_WEAPON_ADVANCED              10   EMPATHY                          11   FLURRY
12   GEAR_HEAD                        13   CONDITIONING                     14   IMPLANT_LEVEL_1
15   IMPLANT_LEVEL_2                  16   IMPLANT_LEVEL_3                  17   IMPROVED_POWER_ATTACK
18   IMPROVED_POWER_BLAST             19   IMPROVED_CRITICAL_STRIKE         20   IMPROVED_SNIPER_SHOT
21   IMPROVED_CONDITIONING            22   MASTER_CONDITIONING
24   MASTER_JEDI_DEFENSE                                                    26   MULTI_SHOT_(MasterRapidShot)
                                      28   POWER_ATTACK                     29   POWER_BLAST
30   RAPID_SHOT                       31   SNIPER_SHOT                      32   WEAPON_FOCUS_BLASTER
33   WEAPON_FOCUS_BLASTER_RIFLE                                             35   WEAPON_FOCUS_HEAVY_WEAPONS
36   WEAPON_FOCUS_LIGHTSABER          37   WEAPON_FOCUS_MELEE_WEAPONS
39   WEAPON_PROF_BLASTER              40   WEAPON_PROF_BLASTER_RIFLE
42   WEAPON_PROF_HEAVY_WEAPONS        43   WEAPON_PROF_LIGHTSABER           44   WEAPON_PROF_MELEE_WEAPONS
                                      46   WEAPON_SPEC_BLASTER              47   WEAPON_SPEC_BLASTER_RIFLE
                                      49   WEAPON_SPEC_HEAVY_WEAPONS        50   WEAPON_SPEC_LIGHTSABER
51   WEAPON_SPEC_MELEE_WEAPONS                                              53   WHIRLWIND_ATTACK_(MasterFlurry)
                                      55   JEDI_DEFENSE                     56   UNCANNY_DODGE_1
57   UNCANNY_DODGE_2
60   SNEAK_ATTACK_1D6                 61   SNEAK_ATTACK_2D6                 62   SNEAK_ATTACK_3D6
63   SNEAK_ATTACK_4D6                 64   SNEAK_ATTACK_5D6                 65   SNEAK_ATTACK_6D6
66   SNEAK_ATTACK_7D6                 67   SNEAK_ATTACK_8D6                 68   SNEAK_ATTACK_9D6
69   SNEAK_ATTACK_10D6

                                                                            77   MASTER_SNIPER_SHOT
78   DROID_UPGRADE_1                  79   DROID_UPGRADE_2                  80   DROID_UPGRADE_3
81   MASTER_CRITICAL_STRIKE           82   MASTER_POWER_BLAST               83   MASTER_POWER_ATTACK
84   TOUGHNESS                        85   TWO_WEAPON_MASTERY
                                      88   FORCE_FOCUS                      89   FORCE_FOCUS_ADVANCED
90   FORCE_FOCUS_MASTERY              91   IMPROVED_FLURRY                  92   IMPROVED_RAPID_SHOT
93   PROFICIENCY_ALL                                                        95   WOOKIE_ENDURANCE
96   BLASTER_INTEGRATION              97   FORCE_CAMOFLAGE                  98   FORCE_IMMUNITY_FEAR
99   FORCE_IMMUNITY_STUN              100  FORCE_IMMUNITY_PARALYSIS         101  FORCE_JUMP
102  FORCE_JUMP_ADVANCED              103  FORCE_JUMP_MASTERY               104  SCOUNDRELS_LUCK
105  IMPROVED_SCOUNDRELS_LUCK         106  MASTER_SCOUNDRELS_LUCK           107  JEDI_SENSE
108  KNIGHT_SENSE                     109  MASTER_SENSE                     110  LOGIC_UPGRADE_COMBAT
111  LOGIC_UPGRADE_TACTICIAN          112  LOGIC_UPGRADE_BATTLE_DROID       113  DUELING
114  ADVANCED_DUELING                 115  MASTER_DUELING                   116  FORCE_SENSITIVE
117  IMPROVED_CAUTION                 118  MASTER_CAUTION                   119  GEAR_HEAD_ADEPT
120  GEAR_HEAD_MASTER                 121  IMPROVED_EMPATHY                 122  MASTER__EMPATHY
123  IMPROVED_TOUGHNESS               124  MASTER_TOUGHNESS
);
our %feats_full = qw (                     1    ADVANCED_JEDI_DEFENSE            2    XXXX_ADVANCED_GUARD_STANCE
3    TWO_WEAPON_FIGHTING              4    ARMOUR_PROF_HEAVY                5    ARMOUR_PROF_LIGHT
6    ARMOUR_PROF_MEDIUM               7    CAUTIOUS                         8    CRITICAL_STRIKE
9    TWO_WEAPON_ADVANCED              10   EMPATHY                          11   FLURRY
12   GEAR_HEAD                        13   CONDITIONING                     14   IMPLANT_LEVEL_1
15   IMPLANT_LEVEL_2                  16   IMPLANT_LEVEL_3                  17   IMPROVED_POWER_ATTACK
18   IMPROVED_POWER_BLAST             19   IMPROVED_CRITICAL_STRIKE         20   IMPROVED_SNIPER_SHOT
21   IMPROVED_CONDITIONING            22   MASTER_CONDITIONING
24   MASTER_JEDI_DEFENSE              25   XXXX_MASTER_GUARD_STANCE         26   MULTI_SHOT
27   XXXX_PERCEPTIVE                  28   POWER_ATTACK                     29   POWER_BLAST
30   RAPID_SHOT                       31   SNIPER_SHOT                      32   WEAPON_FOCUS_BLASTER
33   WEAPON_FOCUS_BLASTER_RIFLE       34   XXXX_WEAPON_FOCUS_GRENADE        35   WEAPON_FOCUS_HEAVY_WEAPONS
36   WEAPON_FOCUS_LIGHTSABER          37   WEAPON_FOCUS_MELEE_WEAPONS       38   XXXX_WEAPON_FOCUS_SIMPLE_WEAPONS
39   WEAPON_PROF_BLASTER              40   WEAPON_PROF_BLASTER_RIFLE        41   XXXX_WEAPON_PROF_GRENADE
42   WEAPON_PROF_HEAVY_WEAPONS        43   WEAPON_PROF_LIGHTSABER           44   WEAPON_PROF_MELEE_WEAPONS
45   XXXX_WEAPON_PROF_SIMPLE_WEAPONS  46   WEAPON_SPEC_BLASTER              47   WEAPON_SPEC_BLASTER_RIFLE
48   XXXX_WEAPON_SPEC_GRENADE         49   WEAPON_SPEC_HEAVY_WEAPONS        50   WEAPON_SPEC_LIGHTSABER
51   WEAPON_SPEC_MELEE_WEAPONS        52   XXXX_WEAPON_SPEC_SIMPLE_WEAPONS  53   WHIRLWIND_ATTACK_(MasterFlurry)
54   XXXX_GUARD_STANCE                55   JEDI_DEFENSE                     56   UNCANNY_DODGE_1
57   UNCANNY_DODGE_2                  58   XXXX_SKILL_FOCUS_COMPUTER_USE
60   SNEAK_ATTACK_1D6                 61   SNEAK_ATTACK_2D6                 62   SNEAK_ATTACK_3D6
63   SNEAK_ATTACK_4D6                 64   SNEAK_ATTACK_5D6                 65   SNEAK_ATTACK_6D6
66   SNEAK_ATTACK_7D6                 67   SNEAK_ATTACK_8D6                 68   SNEAK_ATTACK_9D6
69   SNEAK_ATTACK_10D6                70   XXXX_SKILL_FOCUS_DEMOLITIONS     71   XXXX_SKILL_FOCUS_STEALTH
72   XXXX_SKILL_FOCUS_AWARENESS       73   XXXX_SKILL_FOCUS_PERSUADE        74   XXXX_SKILL_FOCUS_REPAIR
75   XXXX_SKILL_FOCUS_SECURITY        76   XXXX_SKILL_FOCUS_TREAT_INJURY    77   MASTER_SNIPER_SHOT
78   DROID_UPGRADE_1                  79   DROID_UPGRADE_2                  80   DROID_UPGRADE_3
81   MASTER_CRITICAL_STRIKE           82   MASTER_POWER_BLAST               83   MASTER_POWER_ATTACK
84   TOUGHNESS                        85   TWO_WEAPON_MASTERY               86   XXXX_FORCE_FOCUS_ALTER
87   XXXX_FORCE_FOCUS_CONTROL         88   FORCE_FOCUS                      89   FORCE_FOCUS_ADVANCED
90   FORCE_FOCUS_MASTERY              91   IMPROVED_FLURRY                  92   IMPROVED_RAPID_SHOT
93   PROFICIENCY_ALL                  94   BATTLE_MEDITATION                95   WOOKIE_ENDURANCE
96   BLASTER_INTEGRATION              97   FORCE_CAMOFLAGE                  98   FORCE_IMMUNITY_FEAR
99   FORCE_IMMUNITY_STUN              100  FORCE_IMMUNITY_PARALYSIS         101  FORCE_JUMP
102  FORCE_JUMP_ADVANCED              103  FORCE_JUMP_MASTERY               104  SCOUNDRELS_LUCK
105  IMPROVED_SCOUNDRELS_LUCK         106  MASTER_SCOUNDRELS_LUCK           107  JEDI_SENSE
108  KNIGHT_SENSE                     109  MASTER_SENSE                     110  LOGIC_UPGRADE_COMBAT
111  LOGIC_UPGRADE_TACTICIAN          112  LOGIC_UPGRADE_BATTLE_DROID       113  DUELING
114  ADVANCED_DUELING                 115  MASTER_DUELING                   116  FORCE_SENSITIVE
117  IMPROVED_CAUTION                 118  MASTER_CAUTION                   119  GEAR_HEAD_ADEPT
120  GEAR_HEAD_MASTER                 121  IMPROVED_EMPATHY                 122  MASTER__EMPATHY
123  IMPROVED_TOUGHNESS               124  MASTER_TOUGHNESS
);

our %skills=qw(0  ComputerUse  1  Demolitions 2  Stealth  3  Awareness  4  Persuade
5  Repair     6  Security   7  TreatInjury
);
our %genders=qw(
    0 Male
    1 Female
    2 Both
    3 Other
    4 None);
our %powers_short=qw(
                                               4    FORCE_POWER_LIGHT_SABER_THROW_ADVANCED
6    FORCE_POWER_AFFECT_MIND                   7    FORCE_POWER_AFFLICTION                    8    FORCE_POWER_SPEED_BURST
9    FORCE_POWER_CHOKE                         10   FORCE_POWER_CURE                          11   FORCE_POWER_DEATH_FIELD
12   FORCE_POWER_DROID_DISABLE                 13   FORCE_POWER_DROID_DESTROY                 14   FORCE_POWER_DOMINATE
15   FORCE_POWER_DRAIN_LIFE                    16   FORCE_POWER_FEAR                          17   FORCE_POWER_FORCE_ARMOR
18   FORCE_POWER_FORCE_AURA                    19   FORCE_POWER_FORCE_BREACH                  20   FORCE_POWER_FORCE_IMMUNITY
                                               22   FORCE_POWER_FORCE_VALOR                   23   FORCE_POWER_FORCE_PUSH
24   FORCE_POWER_FORCE_SHIELD                  25   FORCE_POWER_FORCE_STORM                   26   FORCE_POWER_FORCE_WAVE
27   FORCE_POWER_FORCE_WHIRLWIND               28   FORCE_POWER_HEAL                          29   FORCE_POWER_STASIS
30   FORCE_POWER_HORROR                        31   FORCE_POWER_INSANITY                      32   FORCE_POWER_KILL
33   FORCE_POWER_KNIGHT_VALOR                  34   FORCE_POWER_KNIGHT_SPEED                  35   FORCE_POWER_LIGHTNING
36   FORCE_POWER_MASTER_VALOR                  37   FORCE_POWER_SPEED_MASTERY                 38   FORCE_POWER_PLAGUE
                                               40   FORCE_POWER_RESIST_ENERGY_2               41   FORCE_POWER_RESIST_FORCE
42   FORCE_POWER_RESIST_ENERGY_1               43   FORCE_POWER_SHOCK                         44   FORCE_POWER_MASS_STASIS
45   FORCE_POWER_SLOW                          46   FORCE_POWER_STUN                          47   FORCE_POWER_DROID_STUN
48   FORCE_POWER_SUPRESS_FORCE                 49   FORCE_POWER_LIGHT_SABER_THROW             50   FORCE_POWER_WOUND
);
our %powers_full=qw(0    FORCE_POWER_MASTER_ALTER_XXX              1    FORCE_POWER_MASTER_CONTROL_XXX            2    FORCE_POWER_MASTER_SENSE_XXX
3    FORCE_POWER_FORCE_JUMP_ADVANCED_XXX       4    FORCE_POWER_LIGHT_SABER_THROW_ADVANCED    5    FORCE_POWER_REGNERATION_ADVANCED_XXX
6    FORCE_POWER_AFFECT_MIND                   7    FORCE_POWER_AFFLICTION                    8    FORCE_POWER_SPEED_BURST
9    FORCE_POWER_CHOKE                         10   FORCE_POWER_CURE                          11   FORCE_POWER_DEATH_FIELD
12   FORCE_POWER_DROID_DISABLE                 13   FORCE_POWER_DROID_DESTROY                 14   FORCE_POWER_DOMINATE
15   FORCE_POWER_DRAIN_LIFE                    16   FORCE_POWER_FEAR                          17   FORCE_POWER_FORCE_ARMOR
18   FORCE_POWER_FORCE_AURA                    19   FORCE_POWER_FORCE_BREACH                  20   FORCE_POWER_FORCE_IMMUNITY
21   FORCE_POWER_FORCE_JUMP_XXX                22   FORCE_POWER_FORCE_VALOR                   23   FORCE_POWER_FORCE_PUSH
24   FORCE_POWER_FORCE_SHIELD                  25   FORCE_POWER_FORCE_STORM                   26   FORCE_POWER_FORCE_WAVE
27   FORCE_POWER_FORCE_WHIRLWIND               28   FORCE_POWER_HEAL                          29   FORCE_POWER_STASIS
30   FORCE_POWER_HORROR                        31   FORCE_POWER_INSANITY                      32   FORCE_POWER_KILL
33   FORCE_POWER_KNIGHT_VALOR                  34   FORCE_POWER_KNIGHT_SPEED                  35   FORCE_POWER_LIGHTNING
36   FORCE_POWER_MASTER_VALOR                  37   FORCE_POWER_SPEED_MASTERY                 38   FORCE_POWER_PLAGUE
39   FORCE_POWER_REGENERATION_XXX              40   FORCE_POWER_RESIST_ENERGY_2               41   FORCE_POWER_RESIST_FORCE
42   FORCE_POWER_RESIST_ENERGY_1               43   FORCE_POWER_SHOCK                         44   FORCE_POWER_MASS_STASIS
45   FORCE_POWER_SLOW                          46   FORCE_POWER_STUN                          47   FORCE_POWER_DROID_STUN
48   FORCE_POWER_SUPRESS_FORCE                 49   FORCE_POWER_LIGHT_SABER_THROW             50   FORCE_POWER_WOUND
51   SPECIAL_ABILITY_BATTLE_MEDITATION_XXXX    52   SPECIAL_ABILITY_BODY_FUEL                 53   SPECIAL_ABILITY_COMBAT_REGENERATION
54   SPECIAL_ABILITY_WARRIOR_STANCE_XXXX       55   SPECIAL_ABILITY_SENTINEL_STANCE_XXXX      56   SPECIAL_ABILITY_DOMINATE_MIND_XXX
57   SPECIAL_ABILITY_PSYCHIC_STANCE            58   SPECIAL_ABILITY_CATHAR_REFLEXES_XXX       59   SPECIAL_ABILITY_ENHANCED_SENSES
60   SPECIAL_ABILITY_CAMOFLAGE                 61   SPECIAL_ABILITY_TAUNT_XXX                 62   SPECIAL_ABILITY_WHIRLING_DERVISH_XXX
63   SPECIAL_ABILITY_RAGE                      64   ITEM_ABILITY_MED_PACK                     65   ITEM_ABILITY_ADVANCED_MED_PACK
66   ITEM_ABILITY_LIFE_SUPPORT_KIT             67   ITEM_ABILITY_REMOVE_POISON                68   PLOT_MAN_ABILITY_SONIC_UPGRADE
69   ITEM_ABILITY_ADRENAL_SHOT_STRENGTH        70   ITEM_ABILITY_ADRENAL_SHOT_ALACRITY        71   ITEM_ABILITY_ADRENAL_SHOT_STAMINA
72   ITEM_ABILITY_HYPER_ADRENAL_SHOT_STRENGTH  73   ITEM_ABILITY_HYPER_ADRENAL_SHOT_ALACRITY  74   ITEM_ABILITY_HYPER_ADRENAL_SHOT_STAMINA
75   ITEM_ABILITY_COMBAT_SHOT_1                76   ITEM_ABILITY_COMBAT_SHOT_2                77   ITEM_ABILITY_COMBAT_SHOT_3
78   ITEM_ABILITY_SHIELD_DISRUPTER             79   ITEM_ABILITY_SHIELD_DISRUPTER_ADVANCED    80   ITEM_ABILITY_OIL_SLICK
81   ITEM_ABILITY_GRAVITY_GENERATOR            82   ITEM_ABILITY_GRAVITY_GENERATOR_ADVANCED   83   MONSTER_ABILITY_SLAM_ATTACK
84   ITEM_ABILITY_DROID_REPAIR_KIT             85   PLOT_TAT_SAND_PERSON_DISGUISE             86   PLOT_TAR_SITH_DISGUISE
87   ITEM_ABILITY_GRENADE_FRAGMENTATION        88   ITEM_ABILITY_GRENADE_STUN                 89   ITEM_ABILITY_GRENADE_THERMAL_DETONATOR
90   ITEM_ABILITY_GRENADE_POISON               91   ITEM_ABILITY_GRENADE_SONIC                92   ITEM_ABILITY_GRENADE_ADHESIVE
93   ITEM_ABILITY_GRENADE_CRYOBAN              94   ITEM_ABILITY_GRENADE_FIRE                 95   ITEM_ABILITY_GRENADE_ION
96   PLOT_UNK_GRENADE_RANCOR                   97   PLOT_KOR_GRENADE_FIRE                     98   PLOT_KOR_GRENADE_COLD
99   ITEM_ABILITY_ENERGY_SHIELD                100  ITEM_ABILITY_SITH_ENERGY_SHIELD           101  ITEM_ABILITY_ARKANIAN_ENERGY_SHIELD
102  ITEM_ABILITY_ECHANI_SHIELD                103  ITEM_ABILITY_MANDLORIAN_MELEE_SHIELD      104  ITEM_ABILITY_MANDLORIAN_POWER_SHIELD
105  ITEM_ABILITY_ECHANI_DUELING_SHIELD        106  ITEM_ABILITY_YUSANIS_DUELING_SHIELD       107  ITEM_ABILITY_VERPINE_ENERGY_SHIELD
108  ITEM_ABILITY_CLOAKING_DEVICE              109  PLOT_LEV_DAMAGE_SPACE_SUIT                110  DROID_ITEM_ENERGY_SHIELD_1
111  DROID_ITEM_ENERGY_SHIELD_2                112  DROID_ITEM_ENERGY_SHIELD_3                113  DROID_ITEM_HAZARD_SHIELD_1
114  DROID_ITEM_HAZARD_SHIELD_2                115  DROID_ITEM_HAZARD_SHIELD_3                116  DROID_ITEM_STUN_RAY_1
117  DROID_ITEM_STUN_RAY_2                     118  DROID_ITEM_SHIELD_DISRUPTOR_1             119  DROID_ITEM_SHIELD_DISRUPTOR_2
120  DROID_ITEM_FLAME_THROWER_1                121  DROID_ITEM_FLAME_THROWER_2                122  DROID_ITEM_CARBONITE_PROJECTOR_1
123  DROID_ITEM_CARBONITE_PROJECTOR_2          124  DROID_ITEM_GRAVITY_GENERATOR_1            125  DROID_ITEM_GRAVITY_GENERATOR_2
126  PLOT_UNK_COLD_SERUM                       127  ITEM_ABILITY_DROID_REPAIR_KIT_ADV         128  ITEM_ABILITY_DROID_CONSTRUCTION_KIT
129  ITEM_ABILITY_RECOVERY_STIM                130  MONSTER_ABILITY_FIRE_BREATH               131  MONSTER_ABILITY_SONIC_HOWL
);

our %appearance_hash=qw(
1    Test                              121  P_FEM_C_SML_01               241  Alien_Gammorean_03               361  Republic_Officer_Fem_Old_Asian
2    Party_NPC_T3M3                    122  P_FEM_C_MED_01               242  Alien_Gammorean_04               362  Republic_Officer_Fem_Old_White
3    Party_NPC_HK47                    123  P_FEM_C_LRG_01               243  Alien_Ithorian_02                363  Republic_Officer_Fem_Old_Black
4    Party_NPC_Bastila                 124  P_FEM_C_SML_02               244  Alien_Ithorian_03                364  Republic_Soldier_Fem_w_Helmet
5    Party_NPC_Cand                    125  P_FEM_C_MED_02               245  Creature_Kath_Hound_A02          365  Unique_Missions_Brother
6    Party_NPC_Carth                   126  P_FEM_C_LRG_02               246  Creature_Kath_Hound_A03          366  Alien_Twilek_Female_03
7    Party_NPC_Jolee                   127  P_FEM_C_SML_03               247  Creature_Kath_Hound_A04          367  Republic_Officer_Fem_White
8    Party_NPC_Juhani                  128  P_FEM_C_MED_03               248  Creature_Kath_Hound_B02          368  Unique_Darth_Malak_JAWLESS
9    Party_NPC_Zaalbar                 129  P_FEM_C_LRG_03               249  Creature_Kath_Hound_B03          369  Unique_Darth_Malak_CINEMATIC
10   Party_NPC_Mission                 130  P_FEM_C_SML_04               250  Creature_Kath_Hound_B04          370  Unique_Sith_Ghost
11   Unique_Admiral_Saul               131  P_FEM_C_MED_04               251  Creature_Wraid_02                371  Unique_Darth_Revan_Male_CUTSCN
12   Alien_Bith_01                     132  P_FEM_C_LRG_04               252  Creature_Wraid_03                372  Unique_Darth_Revan_Female_CUTSCN
13   Unique_Calo_Nord                  133  P_FEM_C_SML_05               253  Creature_Wraid_04                373  Alien_Duros_02
14   Commoner_01_Fem_Asian             134  P_FEM_C_MED_05               254  Alien_Rakata_02                  374  Alien_Duros_03
15   Child_Female                      135  P_FEM_C_LRG_05               255  Alien_Rakata_03                  375  Party_NPC_Bastila_CUTSCN
16   Child_Male                        136  P_MAL_A_SML_01               256  Alien_Rodian_02                  376  Sith_Male_Twilek
17   Commoner_01_Mal_Asian             137  P_MAL_A_MED_01               257  Alien_Rodian_03                  377  Czerka_Officer_Twilek
18   Czerka_Officer_Asian              138  P_MAL_A_LRG_01               258  Alien_Rodian_04                  378  Unique_Trask
19   Dark_Jedi_Female_01               139  P_MAL_A_SML_02               259  Alien_Selkath_02                 379  Dark_Jedi_Master_01
20   Dark_Jedi_Male_01                 140  P_MAL_A_MED_02               260  Alien_Selkath_03                 380  Jedi_Twilek_Male
21   Unique_Darth_Malak                141  P_MAL_A_LRG_02               261  Sith_Soldier_03                  381  Party_NPC_Bastila_SLAVE
22   Unique_Darth_Revan                142  P_MAL_A_SML_03               262  Swoop_Gang_02                    382  Alien_Sand_People_Chief
23   Unique_Admiral_Dodonna            143  P_MAL_A_MED_03               263  Swoop_Gang_03                    383  Lite_Droid_Astro_03
24   Alien_Duros_01                    144  P_MAL_A_LRG_03               264  Swoop_Gang_04                    384  Lite_Droid_Astro_04
25   Commoner_Female_Fat               145  P_MAL_A_SML_04               265  Swoop_Gang_05                    385  Smuggler_02
26   Commoner_Male_Fat                 146  P_MAL_A_MED_04               266  Alien_Sand_People_02             386  Smuggler_03
27   Smuggler_01                       147  P_MAL_A_LRG_04               267  Alien_Sand_People_03             387  Unique_Zaerdra
28   Sith_Soldier_01                   148  P_MAL_A_SML_05               268  Alien_Sand_People_04             388  Unique_Davik
                                       149  P_MAL_A_MED_05               269  Alien_Twilek_Male_02             389  Unique_Gadon
30   Jedi_White_Female_01              150  P_MAL_A_LRG_05               270  Alien_Twilek_Female_02           390  Child_Female_Dirty
31   Jedi_White_Male_01                151  P_MAL_B_SML_01               271  Alien_Wookie_Male_02             391  Child_Male_Dirty
32   Unique_Malek_Jedi                 152  P_MAL_B_MED_01               272  Alien_Wookie_Male_03             392  Lite_Commoner_Female_02
33   Jedi_Council_Member_Female        153  P_MAL_B_LRG_01               273  Alien_Wookie_Male_04             393  Lite_Commoner_Female_03
34   Jedi_Council_Member_Male          154  P_MAL_B_SML_02               274  Alien_Wookie_Male_05             394  Lite_Commoner_Female_04
35   Alien_Mandalorian_01              155  P_MAL_B_MED_02               275  Alien_Wookie_Female_02           395  Lite_Commoner_Female_05
36   Alien_Rakata_01                   156  P_MAL_B_LRG_02               276  Alien_Wookie_Female_03           396  Lite_Commoner_Female_06
37   Republic_Officer_Mal_White        157  P_MAL_B_SML_03               277  Alien_Wookie_Female_04           397  Lite_Commoner_Male_02
38   Republic_Soldier_Mal_White        158  P_MAL_B_MED_03               278  Alien_Wookie_Female_05           398  Lite_Commoner_Male_03
39   Alien_Rodian_01                   159  P_MAL_B_LRG_03               279  EnviromentSuit_02                399  Lite_Commoner_Male_04
40   Alien_Selkath_01                  160  P_MAL_B_SML_04               280  Unique_Yuthura_Ban               400  Lite_Commoner_Male_05
41   Dark_Jedi_Sith_Apprentice         161  P_MAL_B_MED_04               281  Creature_Shyrack_01              401  Lite_Commoner_Male_06
42   Sith_Female_Albino                162  P_MAL_B_LRG_04               282  Creature_Shyrack_02              402  Lite_Commoner_Male_B01
43   Sith_Male_Albino                  163  P_MAL_B_SML_05               283  Republic_Soldier_Mal_Black       403  Lite_Commoner_Male_B02
44   Sith_Soldier_02                   164  P_MAL_B_MED_05               284  Republic_Soldier_Mal_Old_Asian   404  Lite_Commoner_Male_B03
45   Swoop_Gang_01                     165  P_MAL_B_LRG_05               285  Republic_Soldier_Mal_Old_White   405  Lite_Commoner_Male_B04
46   Alien_Sand_People_01              166  P_MAL_C_SML_01               286  Republic_Soldier_Mal_Old_Black   406  Lite_Commoner_Male_B05
47   Alien_Twilek_Female_01            167  P_MAL_C_MED_01               287  Republic_Officer_Mal_Black       407  Lite_Commoner_Female_B01
48   Alien_Twilek_Male_01              168  P_MAL_C_LRG_01               288  Republic_Officer_Mal_Old_Asian   408  Lite_Commoner_Female_B02
49   Alien_Walrusman                   169  P_MAL_C_SML_02               289  Republic_Officer_Mal_Old_White   409  Lite_Commoner_Female_B03
50   Alien_Wookie_Female_01            170  P_MAL_C_MED_02               290  Republic_Officer_Mal_Old_Black   410  Lite_Commoner_Female_B04
51   Alien_Wookie_Male_01              171  P_MAL_C_LRG_02               291  Sith_Fem_White                   411  Lite_Commoner_Female_B05
52   Unique_Vandar                     172  P_MAL_C_SML_03               292  Sith_Fem_Black                   412  Unique_Deadeye
53   Creature_Bantha                   173  P_MAL_C_MED_03               293  Sith_Fem_Old_Asian               413  Unique_Brejik
54   Creature_Brith                    174  P_MAL_C_LRG_03               294  Sith_Fem_Old_White               414  Unique_Gendar
55   Creature_Dewback                  175  P_MAL_C_SML_04               295  Sith_Fem_Old_Black               415  Unique_Uthar
56   Droid_Assassin                    176  P_MAL_C_MED_04               296  Sith_Mal_White                   416  Unique_Zhar
57   Droid_Astro_01                    177  P_MAL_C_LRG_04               297  Sith_Mal_Black                   417  Unique_Xor
58   Droid_Nul                         178  P_MAL_C_SML_05               298  Sith_Mal_Old_Asian               418  Alien_Walrusman02
59   Droid_Mark_Four                   179  P_MAL_C_MED_05               299  Sith_Mal_Old_White               419  Alien_Walrusman03
60   Droid_Mark_One                    180  P_MAL_C_LRG_05               300  Sith_Mal_Old_Black               420  Alien_Walrusman04
61   Droid_Mark_Two                    181  EnviromentSuit_01            301  Sith_Fem_Asian                   421  Dark_Jedi_Master_02
62   Droid_Probe                       182  Turret_01                    302  Sith_Mal_Asian                   422  Dark_Jedi_Master_03
63   Droid_Protocol_01                 183  Turret_02                    303  Jedi_White_Old_Male              423  Unique_Dorak
64   Droid_Sentry                      184  Unique_Darth_Bandon          304  Jedi_Asian_Old_Male              424  Unique_Vrook
65   Droid_Spyder                      185  Commoner_01_Fem_White        305  Jedi_Black_Old_Male              425  Czerka_Commander
66   Droid_War_01                      186  Commoner_01_Fem_Black        306  Jedi_White_Old_Fem               426  Czerka_Protcol_OfficerF
67   Creature_Firixa                   187  Commoner_01_Fem_Old_Asian    307  Jedi_Asian_Old_Fem               427  Lite_Wookie_Female
68   Alien_Gammorean_01                188  Commoner_01_Fem_Old_White    308  Jedi_Black_Old_Fem               428  Tatooine_comm_Asian_Male
69   Creature_Gizka                    189  Commoner_01_Fem_Old_Black    309  Creature_Rancor_Small            429  Tatooine_comm_Asian_Female
70   Alien_Hutt_01                     190  Commoner_01_Mal_White        310  Unique_Holo_Vandar               430  Tatooine_comm_White_Male
71   Creature_Iriaz                    191  Commoner_01_Mal_Black        311  Unique_Holo_Dodonna              431  Tatooine_comm_White_Female
72   Alien_Ithorian_01                 192  Commoner_01_Mal_Old_Asian    312  Unique_Holo_Rakata               432  Unique_Dustil
73   Alien_Jawa                        193  Commoner_01_Mal_Old_White    313  Lite_Droid_Astro_01              433  Unique_Jorak
74   Creature_Kataarn                  194  Commoner_01_Mal_Old_Black    314  Lite_Droid_Astro_02              434  Unique_Lashowe
75   Creature_Kath_Hound_A01           195  Czerka_Officer_White         315  Lite_Commoner_Female_01          435  Unique_MekelH
76   Creature_Kath_Hound_B01           196  Czerka_Officer_Black         316  Lite_Commoner_Male_01            436  Droid_Mark_One_Red
77   Creature_Krayt_Dragon             197  Czerka_Officer_Old_Asian     317  Lite_Protocol_01                 437  Droid_Spyder_Red
78   Creature_Mykal                    198  Czerka_Officer_Old_White     318  Lite_Protocol_02                 438  Unique_Shaleena
79   Creature_Rakghoul                 199  Czerka_Officer_Old_Black     319  Lite_Jawa                        439  Creature_Kinrath_Var_Blue
80   Creature_Rancor                   200  Jedi_White_Female_02         320  Lite_Rakata_01                   440  Creature_Kinrath_Var_Red
81   Creature_SeaBeast                 201  Jedi_White_Female_03         321  Lite_Republic_Officer_Mal_White  441  Creature_Kinrath_Var_Green
                                       202  Jedi_White_Female_04         322  Lite_Republic_Officer_Fem_White  442  Unique_Shaardan
83   Creature_Tach                     203  Jedi_White_Female_05         323  Lite_Selkath_01                  443  Creature_Kataarn02
84   Alien_TwoHead                     204  Jedi_Asian_Female_01         324  Lite_Swoop_Gang                  444  Unique_Tanis
85   Creature_Verkaal                  205  Jedi_Asian_Female_02         325  Lite_Twilek_Female               445  Unique_Komad
86   Creature_Wraid_01                 206  Jedi_Asian_Female_03         326  Lite_Twilek_Male                 446  Alien_Twilek_Female_Green
87   Creature_Ronto                    207  Jedi_Asian_Female_04         327  Lite_Wookie_Male                 447  Alien_Twilek_Female_Orange
88   Creature_Kinrath                  208  Jedi_Asian_Female_05         328  LiteL_Alien01                    448  Alien_Twilek_Female_Yellow
89   Creature_Tukata                   209  Jedi_Black_Female_01         329  LiteL_Alien02                    449  Alien_Twilek_Male_Green
90   Alien_Sand_Person_Female          210  Jedi_Black_Female_02         330  LiteL_Alien05                    450  Alien_Twilek_Male_Orange
91   P_FEM_A_SML_01                    211  Jedi_Black_Female_03         331  Lite_Sith_Off_F                  451  Alien_Rodian_05
92   P_FEM_A_MED_01                    212  Jedi_Black_Female_04         332  Lite_Sith_Off_M                  452  Alien_Trandoshan_01
93   P_FEM_A_LRG_01                    213  Jedi_Black_Female_05         333  Lite_SpaceMan                    453  Alien_Trandoshan_02
94   P_FEM_A_SML_02                    214  Jedi_White_Male_02           334  Creature_Rancor_CUTSCN           454  Commoner_02_Fem_White
95   P_FEM_A_MED_02                    215  Jedi_White_Male_03           335  Alien_Selkath_Insane_01          455  Commoner_02_Fem_Black
96   P_FEM_A_LRG_02                    216  Jedi_White_Male_04           336  Alien_Selkath_Insane_02          456  Commoner_02_Fem_Old_Asian
97   P_FEM_A_SML_03                    217  Jedi_White_Male_05           337  Alien_Gammorean_Civilian         457  Commoner_02_Fem_Old_White
98   P_FEM_A_MED_03                    218  Jedi_Asian_Male_01           338  Lite_Sith_Soldier                458  Commoner_02_Fem_Old_Black
99   P_FEM_A_LRG_03                    219  Jedi_Asian_Male_02           339  Commoner_Dirty_Fem_Asian         459  Commoner_02_Mal_White
100  P_FEM_A_SML_04                    220  Jedi_Asian_Male_03           340  Commoner_Dirty_Fem_White         460  Commoner_02_Mal_Black
101  P_FEM_A_MED_04                    221  Jedi_Asian_Male_04           341  Commoner_Dirty_Fem_Black         461  Commoner_02_Mal_Old_Asian
102  P_FEM_A_LRG_04                    222  Jedi_Asian_Male_05           342  Commoner_Dirty_Fem_Old_Asian     462  Commoner_02_Mal_Old_White
103  P_FEM_A_SML_05                    223  Jedi_Black_Male_01           343  Commoner_Dirty_Fem_Old_White     463  Commoner_02_Mal_Old_Black
104  P_FEM_A_MED_05                    224  Jedi_Black_Male_02           344  Commoner_Dirty_Fem_Old_Black     464  Commoner_02_Fem_Asian
105  P_FEM_A_LRG_05                    225  Jedi_Black_Male_03           345  Commoner_Dirty_Mal_Asian         465  Commoner_02_Mal_Asian
106  P_FEM_B_SML_01                    226  Jedi_Black_Male_04           346  Commoner_Dirty_Mal_White         466  Czerka_Officer_White_02
107  P_FEM_B_MED_01                    227  Jedi_Black_Male_05           347  Commoner_Dirty_Mal_Black         467  Czerka_Officer_Black_02
108  P_FEM_B_LRG_01                    228  Alien_Hutt_02                348  Commoner_Dirty_Mal_Old_Asian     468  Czerka_Officer_Old_Asian_02
109  P_FEM_B_SML_02                    229  Alien_Hutt_03                349  Commoner_Dirty_Mal_Old_White     469  Czerka_Officer_Old_White_02
110  P_FEM_B_MED_02                    230  Alien_Hutt_04                350  Commoner_Dirty_Mal_Old_Black     470  Czerka_Officer_Old_Black_02
111  P_FEM_B_LRG_02                    231  Droid_Astro_02               351  Alien_Mandalorian_02             471  Commoner_Dirty_02_Fem_Asian
112  P_FEM_B_SML_03                    232  Droid_Astro_03               352  Alien_Mandalorian_03             472  Commoner_Dirty_02_Fem_White
113  P_FEM_B_MED_03                    233  Droid_Protocol_02            353  Creature_Terantanak              473  Commoner_Dirty_02_Fem_Black
114  P_FEM_B_LRG_03                    234  Droid_Protocol_03            354  Creature_Krayt_Dragon_CUTSCN     474  Commoner_Dirty_02_Fem_Old_Asian
115  P_FEM_B_SML_04                    235  Droid_Protocol_04            355  Republic_Soldier_Mal_w_Helmet    475  Commoner_Dirty_02_Fem_Old_White
116  P_FEM_B_MED_04                    236  Droid_War_02                 356  Republic_Soldier_Fem_Black       476  Commoner_Dirty_02_Fem_Old_Black
117  P_FEM_B_LRG_04                    237  Droid_War_03                 357  Republic_Soldier_Fem_Old_Asian   477  Commoner_Dirty_02_Mal_Asian
118  P_FEM_B_SML_05                    238  Droid_War_04                 358  Republic_Soldier_Fem_Old_White   478  Commoner_Dirty_02_Mal_White
119  P_FEM_B_MED_05                    239  Droid_War_05                 359  Republic_Soldier_Fem_Old_Black   479  Commoner_Dirty_02_Mal_Black
120  P_FEM_B_LRG_05                    240  Alien_Gammorean_02           360  Republic_Officer_Fem_Black       480  Commoner_Dirty_02_Mal_Old_Asian

481  Commoner_Dirty_02_Mal_Old_White
482  Commoner_Dirty_02_Mal_Old_Black
483  Czerka_Officer_Twilek_02
484  Czerka_Officer_Asian_02
485  Sith_Fem_White_02
486  Sith_Fem_Black_02
487  Sith_Fem_Old_Asian_02
488  Sith_Fem_Old_White_02
489  Sith_Fem_Old_Black_02
490  Sith_Mal_White_02
491  Sith_Mal_Black_02
492  Sith_Mal_Old_Asian_02
493  Sith_Mal_Old_White_02
494  Sith_Mal_Old_Black_02
495  Sith_Fem_Asian_02
496  Sith_Mal_Asian_02
497  Republic_Officer_Mal_Asian_02
498  Republic_Officer_Mal_Black_02
499  Republic_Officer_Mal_Old_Asian_02
500  Republic_Officer_Mal_Old_Black_02
501  Republic_Officer_Mal_Old_White_02
502  Republic_Officer_Mal_White_02
503  Republic_Soldier_Mal_Black_02
504  Republic_Soldier_Mal_Black_02
505  Republic_Soldier_Mal_Old_Asian_02
506  Republic_Soldier_Mal_Old_Black_02
507  Republic_Soldier_Mal_Old_White_02
508  Republic_Soldier_Mal_White_02     );

our %portraits_hash=qw(
1   po_pfha1    11  po_pfhb1  21  po_pmha4 31  po_pmhb4
2   po_pfha2    12  po_pfhb2  22  po_pmha5 32  po_pmhb5
3   po_pfha3    13  po_pt3m3  23  po_pmhc1 33  po_pbastila
4   po_pfha4    14  po_pcarth 24  po_pmhc2 34  po_phk47
5   po_pfha5    15  po_pfhb3  25  po_pmhc3 35  po_pmission
6   po_pfhc1    16  po_pfhb4  26  po_pmhc4 36  po_pzaalbar
7   po_pfhc2    17  po_pfhb5  27  po_pmhc5 37  po_pjuhani
8   po_pfhc3    18  po_pmha1  28  po_pmhb1 38  po_pjolee
9   po_pfhc4    19  po_pmha2  29  po_pmhb2 39  po_pcanderous
10  po_pfhc5    20  po_pmha3  30  po_pmhb3 40  po_ptrask);

our %soundset_hash=qw(
1   c_bantha        30  c_veerkal       59  n_rodian
2   c_brith         31  c_wraid         60  n_selkath
3   c_drdassassin   32  n_admrlsaulkar  61  n_sithappren
4   c_drdastro      33  n_bith          62  n_sithapprenf
5   c_drdmkfour     34  n_calonord      63  n_sithapprenm
6   c_drdmkone      35  n_commf         64  n_sithcomf
7   c_drdmktwo      36  n_commkidf      65  n_sithcomm
8   c_drdprobe      37  n_commkidm      66  n_sithsoldr
9   c_drdprotocol   38  n_commm         67  n_swoopgang
10  c_drdsentry     30  n_czerkaoff     68  n_tusken
11  c_drdspyder     40  n_darkjedif     69  n_twilekf
12  c_drdwar        41  n_darkjedim     70  n_twilekm
13  c_frixa         42  n_darth_malek   71  n_walrusman
14  c_gammorean     43  n_dodonna       72  n_wookieef
15  c_hutt          44  n_duros         73  n_wookieem
16  c_iriaz         45  n_fatcomf       74  n_yoda
17  c_katarn        46  n_fatcomm       75  p_bastila
18  c_KhoundA       47  n_humansmuggler 76  p_cand
19  c_KhoundB       48  n_ithorian      77  p_carth
20  c_kinrath       49  n_jawa          78  p_hk47
21  c_kraytdragon   50  n_jedicounf     79  p_jolee
22  c_mykal         51  n_jedicounm     80  p_juhani
23  c_rakghoul      52  n_jediMalek     81  p_mission
24  c_rancor        53  n_jedimemf      82  p_playerfb
25  c_ronto         54  n_jedimemm      83  p_playerfw
26  c_seabeast      55  n_mandalorian   84  p_playermb
27  c_tach          56  n_rakata        85  p_playermw
28  c_tukata        57  n_repoff        86  p_t3m4
29  c_twohead       58  n_repsold       87  p_zaalbar

88  c_terantank
89  n_trandoshan);


our $registered_path;
our $debug_flag;
our $short_or_long=0;
our $inventory_in_memory=0;
our $inventory_source_treeitem;
our $inventory_source_savegame_name;
our $inventory_memorized;
our $old_tix_image;

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if (-e "kse.log") {
    open STDERR, ">>", "kse.log";
    $debug_flag=1;
}
LogIt ('KSE startup '.$version);
our $mw=MainWindow->new(-title=>'KotOR Savegame Editor',-relief=>'groove');                     #Create main window
$mw->geometry($x."x$y");                                                                        #Size of main window
my $icon;
#%powers=%powers_full; #I'm lazy
#%feats=%feats_full;
eval {  my $iconfile="boba.bmp";  $icon=PerlApp::extract_bound_file($iconfile); };              #Extract .bmp from .exe
unless ($@) {
    my $image = $mw->Photo(-file => $icon, -format => 'bmp');                                   #apply .bmp as application icon
    $mw->Icon(-image => $image);
}
our $tree=$mw->ScrlTree(-scrollbars=>'osoe',                                                    #create the tree
                        -separator=>'#',
                        -browsecmd=>\&What,
                        -background=>"#e0e0e0"
)->place(-relx=>10/$x,-rely=>10/$y,-relheight=>580/$y,-relwidth=>580/$x);
$tree->bind('<ButtonPress-3>'=>\&RWhat);

$mw->Label(-text=>$version)->place(-relx=>890/$x,-rely=>590/$y,-anchor=>'se');                  #create version label




eval { my  $kotor_key= new Win32::TieRegistry "LMachine/Software/Bioware/SW/Kotor",             #read registry
          {Access=>Win32::TieRegistry::KEY_READ, Delimiter=>"/"};
        $registered_path= $kotor_key->GetValue("Path") };
if ($@) {                                                                                       #or tell user to browse for it
    unless ($registered_path=BrowseForFolder('Locate SW:KotOR installation directory')){exit;}}
    unless (opendir SAVDIR, $registered_path."/saves") {                                        #saves directory not found
    $mw->messageBox(-title=>'Directory not found',
                    -message=>'Could not find saves directory in installation path',-type=>'Ok');
    LogIt ('KSE could not find saves directory. Exiting.');
    exit;
}
if (-e $registered_path."/override/spells.2da") {
    %powers_full=Bioware::TwoDA::get_2da_rows_and_1stcol($registered_path."/override/spells.2da");
    LogIt ('spells.2da override detected.');
}
if (-e $registered_path."/override/appearance.2da") {
    %appearance_hash=Bioware::TwoDA::get_2da_rows_and_1stcol($registered_path."/override/appearance.2da");
    LogIt ('appearance.2da override detected.');
}
if (-e $registered_path."/override/portraits.2da") {
    %portraits_hash=Bioware::TwoDA::get_2da_rows_and_1stcol($registered_path."/override/portraits.2da");
    LogIt ('portraits.2da override detected.');
}
if (-e $registered_path."/override/soundset.2da") {
    %soundset_hash=Bioware::TwoDA::get_2da_rows_and_1stcol($registered_path."/override/soundset.2da");
    LogIt ('soundset.2da override detected.');
}
LogIt ('KSE found saves directory in ' . $registered_path);
my @savedirs=grep { !(/\\\.+$/) && -d } map {"$registered_path\\saves\\$_"} readdir(SAVDIR);    #read all directories in saves dir
close SAVDIR;
$tree->add('#',-text=>'SAVEGAMES');                                                             #populate tree with directories
for (@savedirs) {
    /\\.*\\(.+?)$/;
    my $dir=$1;
    $tree->add('#'.$dir,-text=>$dir);
    $tree->add('#'.$dir.'#',-text=>'.');
    $tree->hide('entry','#'.$dir.'#');                                                          #give them something to talk about
}
$tree->autosetmode();                                                                           #show the [+] symbols
our @spawned_widgets;                                                                           #for later...

our %master_item_list=();






MainLoop;
LogIt ("---------Termination---------");
close STDERR;
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

sub updscrl {
    $bandaid++;
    $tree->Subwidget('yscrollbar')->eventGenerate('<Expose>');
    if ($bandaid<10) {
        $tree->Subwidget('yscrollbar')->after(1000,\&updscrl);
    }
}
############################
sub What {  #called by BrowseCmd
############################
    my $parm1=shift;
    LogIt ("$parm1 clicked");

    $bandaid=0; #ouch! (This is to make the scrollbars update.)
    $tree->Subwidget('yscrollbar')->after(1000,\&updscrl);

# if the data can be modified, spawn the widgets on the right side
# to allow for modification.  Normally, the -data property of the
# leaf is set to 'can modify' to indicate this.  The one exception
# is when changing NPC's names.  The -data field on this leaf is the
# npc's original gff object, so we make construct our if statement as follows:
    if ( ($tree->entrycget($parm1,-data) eq 'can modify') || ((split /#/, $parm1)[-1] =~ /NPC\d+/) )
    {
        unless ($tree->info('exists',$parm1."#")) {  #first time opening node
            SpawnWidgets($parm1);
        }
    }
    else {
        for my $widge (@spawned_widgets) {   #unspawn old widgets
        $widge->destroy if Tk::Exists($widge);    }
        @spawned_widgets=();
    }
    my $mode=$tree->getmode($parm1);

    if ($leaf_memory{$parm1} eq $mode){  #this bit prevents re-entry
        return;
    }

    $leaf_memory{$parm1}=$mode;
    if ($mode eq 'none') { return; }
    if ($mode eq 'close') {
        if ($tree->info('exists',$parm1."#")) {  #first time opening node
            $tree->delete('entry',$parm1."#");
            my @levels=split /#/,$parm1;
            if ($#levels == 1) { Populate_Level1($parm1); Populate_Feats($parm1.'#Feats');}
            if ($#levels == 2) {
                if    ($levels[2] eq 'Skills')  { Populate_Skills($parm1)  }
                elsif ($levels[2] eq 'Feats')   {    } #feat populating now occurs when $#levels==1
                elsif ($levels[2] eq 'Classes') { Populate_Classes($parm1) }
                elsif ($levels[2] eq 'NPCs')    { Populate_NPCs($parm1)    }
                elsif ($levels[2] eq 'Globals') { Read_Global_Vars("$registered_path\\saves\\$levels[1]",$parm1)}
                elsif ($levels[2] eq 'Inventory') { Populate_Inventory($parm1) }
            }
            if ($#levels == 3) {
                if    ($levels[2] eq 'NPCs')    { Populate_NPC($parm1)     }
            }
        }
    }

}


#>>>>>>>>>>>>>>>>>>>>>>
sub Populate_Level1 {
#>>>>>>>>>>>>>>>>>>>>>>
    my $treeitem=shift;
    LogIt ("Populating Level1 for $treeitem");
    my $gamedir=(split /#/,$treeitem)[1];

#read the SAVENFO.RES file
    my $res_gff=Bioware::GFF->new();
    unless (my $tmp=$res_gff->read_gff_file("$registered_path\\saves\\$gamedir\\savenfo.res")) {
        die ("Could not read $registered_path\\saves\\$gamedir\\savenfo.res");
    }
    my $time_played=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('TIMEPLAYED')]{Value};
    my $area_name=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('AREANAME')]{Value};
    my $save_game_name=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('SAVEGAMENAME')]{Value};
    my $last_module=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('LASTMODULE')]{Value};
    my $cheat=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('CHEATUSED')]{Value};

#read the PARTYTABLE.RES file
    my $pty_gff=Bioware::GFF->new();
    unless (my $tmp=$pty_gff->read_gff_file("$registered_path\\saves\\$gamedir\\partytable.res")) {
        die ("Could not read $registered_path\\saves\\$gamedir\\partytable.res");
    }
    my $credits=$pty_gff->{Main}{Fields}[$pty_gff->{Main}->get_field_ix_by_label('PT_GOLD')]{Value};
    my $partyxp=$pty_gff->{Main}{Fields}[$pty_gff->{Main}->get_field_ix_by_label('PT_XP_POOL')]{Value};
    my $pty_cheat=$pty_gff->{Main}{Fields}[$pty_gff->{Main}->get_field_ix_by_label('PT_CHEAT_USED')]{Value};
    my @avail_npcs;
    my $npc_structs_arr_ref=$pty_gff->{Main}{Fields}[$pty_gff->{Main}->get_field_ix_by_label('PT_AVAIL_NPCS')]{Value};
    my $i=0;
    for my $npc_struct (@$npc_structs_arr_ref) {
        my $is_available=$npc_struct->{Fields}[$npc_struct->get_field_ix_by_label('PT_NPC_AVAIL')]{Value};
        if ($is_available==1) {
            push @avail_npcs,$i;
        }
        $i++;
    }
    my $avail_npcs_ref=\@avail_npcs;


#read the SAVEGAME.SAV file

    my $erf=Bioware::ERF->new();                                            #create ERF for savegame.sav
                                                                            #read savegame.sav structure
    unless (my $tmp=$erf->read_erf("$registered_path\\saves\\$gamedir\\savegame.sav")) {
        die "Could not read $registered_path\\saves\\$gamedir\\savegame.sav";
    }
    my $tmpfil_inv;
    unless ($tmpfil_inv=$erf->export_resource_to_temp_file("INVENTORY.res")) {     #export inventory.res as a temp file
        die "Could not find INVENTORY.res inside of $registered_path\\saves\\$gamedir\\savegame.sav";
    }
    my $gff_inv=Bioware::GFF->new();                                        #create GFF for inventory.res
    unless (my $tmp=$gff_inv->read_gff_file($tmpfil_inv->{'fn'})) {         #read invenotry.res into GFF
        die "Could not read from temp file containing INVENTORY.res";
    }
    my $tmpfil_sav;
    unless ($tmpfil_sav=$erf->export_resource_to_temp_file("$last_module.sav")) {  #export the last module as a temp file
        die "Could not find $last_module.sav inside of $registered_path\\saves\\$gamedir\\savegame.sav";
    }
    my $erf2=Bioware::ERF->new();                                           #create ERF for last module
    unless (my $tmp=$erf2->read_erf($tmpfil_sav->{'fn'})) {                 #read last module structure
        die "Could not read from temp file containing $last_module.sav";
    }
    $erf2->{'tmpfil'}=$tmpfil_sav;                                          #tuck the temp file into the erf for safekeeping
    $erf2->{'modulename'}="$last_module.sav";                               #tuck the module name into the erf for safekeeping
    my $tmpfil_ifo;
    unless($tmpfil_ifo=$erf2->export_resource_to_temp_file("module.ifo")) {       #export the module.ifo file as a temp file
        die "Could not find module.ifo inside of $last_module.sav";
    }
    my $gff_ifo=Bioware::GFF->new();                                        #create GFF for module.ifo
    unless (my $tmp=$gff_ifo->read_gff_file($tmpfil_ifo->{'fn'})) {                           #read module.ifo into GFF
        die "Could not read from temp file containing module.ifo";
    }

    my $mod_playerlist=$gff_ifo->{Main}{Fields}[$gff_ifo->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];

    my $firstname     =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FirstName')]{'Value'}{'Substrings'}[0]{'Value'};
    my $gender        =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Gender')]{'Value'};
    my $att_str       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Str')]{'Value'};
    my $att_dex       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Dex')]{'Value'};
    my $att_con       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Con')]{'Value'};
    my $att_int       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Int')]{'Value'};
    my $att_wis       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Wis')]{'Value'};
    my $att_cha       =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Cha')]{'Value'};
    my $hitpoints     =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('HitPoints')]{'Value'};
    my $maxhitpoints  =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('MaxHitPoints')]{'Value'};
    my $forcepoints   =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ForcePoints')]{'Value'};
    my $maxforcepoints=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('MaxForcePoints')]{'Value'};
    my $min1hp        =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Min1HP')]{'Value'};
    my $experience    =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Experience')]{'Value'};
    my $goodevil      =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('GoodEvil')]{'Value'};
    my $appearance    =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Appearance_Type')]{'Value'};
    my $portrait      =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('PortraitId')]{'Value'};
    my $soundset      =$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('SoundSetFile')]{'Value'};


    $tree->add($treeitem."#SaveGameName", -text=>'Savegame Name: ' . $save_game_name, -data=>'can modify');
    $tree->add($treeitem."#Area", -text=>'Area Name: '. $area_name,-data=>$area_name);
    $tree->add($treeitem."#LastModule",-text=>'Last Module: '.$last_module,-data=>$last_module);
    $tree->add($treeitem."#FirstName",-text=>"Player Name: $firstname",-data=>'can modify');
    $tree->add($treeitem."#Gender",-text=>"Gender: $genders{$gender}",-data=>'can modify');
    $tree->add($treeitem."#Appearance",-text=>"Appearance: $appearance_hash{$appearance}",-data=>'can modify');
    $tree->add($treeitem."#Portrait",-text=>"Portrait: $portraits_hash{$portrait}",-data=>'can modify');
    $tree->add($treeitem."#Soundset",-text=>"Soundset: $soundset_hash{$soundset}",-data=>'can modify');
    $tree->add($treeitem."#Attributes",-text=>"Attributes");
    $tree->add($treeitem."#NPCs",-text=>"NPCs",-data=>$avail_npcs_ref);
    $tree->add($treeitem."#NPCs#",-text=>'');  $tree->hide('entry',$treeitem."#NPCs#");
    $tree->add($treeitem."#Globals",-text=>'Globals');
    $tree->add($treeitem."#Globals#",-text=>''); $tree->hide('entry',$treeitem."#Globals#");
    $tree->add($treeitem."#TimePlayed",-text=>'Time Played: '.
                                                               (sprintf "%uh ",($time_played/3600)).
                                                               (sprintf "%um ",(($time_played % 3600)/60)).
                                                               (sprintf "%us",($time_played % 60)),
              -data=>'can modify');
    $tree->add($treeitem."#CheatUsed",-text=>"Cheat Used: " . ($pty_cheat | $cheat),-data=>'can modify');
    $tree->add($treeitem."#Attributes#STR",-text=>"STR: $att_str",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#STR");
    $tree->add($treeitem."#Attributes#DEX",-text=>"DEX: $att_dex",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#DEX");
    $tree->add($treeitem."#Attributes#CON",-text=>"CON: $att_con",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#CON");
    $tree->add($treeitem."#Attributes#INT",-text=>"INT: $att_int",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#INT");
    $tree->add($treeitem."#Attributes#WIS",-text=>"WIS: $att_wis",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#WIS");
    $tree->add($treeitem."#Attributes#CHA",-text=>"CHA: $att_cha",-data=>'can modify'); $tree->hide('entry',$treeitem."#Attributes#CHA");
    $tree->add($treeitem."#HitPoints",-text=>"Hit Points: $hitpoints",-data=>'can modify');
    $tree->add($treeitem."#MaxHitPoints",-text=>"Max Hit Points: $maxhitpoints",-data=>'can modify');
    $tree->add($treeitem."#Min1HP",-text=>"Min1HP: $min1hp",-data=>'can modify');
    $tree->add($treeitem."#ForcePoints",-text=>"Force Points: $forcepoints",-data=>'can modify');
    $tree->add($treeitem."#MaxForcePoints",-text=>"MaxForce Points: $maxforcepoints",-data=>'can modify');
    $tree->add($treeitem."#Classes",-text=>"Classes");
    $tree->add($treeitem."#Classes#",-text=>""); $tree->hide('entry',$treeitem."#Classes#");
    $tree->add($treeitem."#Experience",-text=>"Experience: $experience",-data=>'can modify');
    $tree->add($treeitem."#GoodEvil",-text=>"GoodEvil: $goodevil",-data=>'can modify');
    $tree->add($treeitem."#Skills",-text=>"Skills");
    $tree->add($treeitem."#Feats",-text=>"Feats",-data=>'can modify');
    $tree->add($treeitem."#Skills#",-text=>"");  $tree->hide('entry',$treeitem."#Skills#");
    $tree->add($treeitem."#Feats#",-text=>"");   $tree->hide('entry',$treeitem."#Feats#");
    $tree->add($treeitem."#Credits",-text=>"Credits: $credits",-data=>'can modify');
    $tree->add($treeitem."#PartyXP",-text=>"Party XP: $partyxp",-data=>'can modify');
    $tree->add($treeitem."#Inventory",-text=>"Inventory");
    $tree->add($treeitem."#Inventory#",-text=>"");  $tree->hide('entry',$treeitem."#Inventory#");
    $tree->entryconfigure($treeitem,-data=>{'ERF-sav'=>$erf,'ERF-mod'=>$erf2,'GFF-pty'=>$pty_gff,'GFF-res'=>$res_gff,'GFF-ifo'=>$gff_ifo,'GFF-inv'=>$gff_inv});
    $tree->autosetmode();

}
#>>>>>>>>>>>>>>>>>>>>
sub Read_Global_Vars{
#>>>>>>>>>>>>>>>>>>>>
    my $dir=shift;
    my $treeitem=shift;
    #$tree->add($treeitem."#Globals",-text=>"Globals");
    $tree->add($treeitem."#Booleans",-text=>"Booleans");
    $tree->add($treeitem."#Numerics",-text=>"Numerics");

    my $gff=Bioware::GFF->new();
    $gff->read_gff_file("$dir\\GLOBALVARS.res");

    my %boogleans;
    my %numrics;
    my $bitstring=unpack('B*',$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('ValBoolean')]{'Value'});
    my @bits=split //,$bitstring;
    my $catboolean_ix=$gff->{Main}->get_field_ix_by_label('CatBoolean');
    for (my $i=0; $i< scalar @{$gff->{Main}{Fields}[$catboolean_ix]{'Value'}}; $i++) {
        my $kee=$gff->{Main}{Fields}[$catboolean_ix]{'Value'}[$i]{'Fields'}{'Value'}."__$i";
        $boogleans{$kee}=$bits[$i];
    }
    for my $kee (sort keys %boogleans) {
        my $keetxt=(split /__/,$kee)[0];
        $tree->add("$treeitem#Booleans#$kee",-text=>"$keetxt: $boogleans{$kee}",-data=>'can modify');
        $tree->hide('entry',"$treeitem#Booleans#$kee");
    }
    my $catnumber_ix=$gff->{Main}->get_field_ix_by_label('CatNumber');
    my $catnumber_count=scalar @{$gff->{Main}{Fields}[$catboolean_ix]{'Value'}};
    my @byts=unpack("C$catnumber_count",$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('ValNumber')]{'Value'});
    for (my $i=0; $i< scalar @{$gff->{Main}{Fields}[$catnumber_ix]{'Value'}}; $i++) {
        my $kee=$gff->{Main}{Fields}[$catnumber_ix]{'Value'}[$i]{'Fields'}{'Value'}."__$i";
        $numrics{$kee}=$byts[$i];
    }
    for my $kee (sort keys %numrics) {
        my $keetxt=(split /__/,$kee)[0];
        $tree->add("$treeitem#Numerics#$kee",-text=>"$keetxt: $numrics{$kee}",-data=>'can modify');
        $tree->hide('entry',"$treeitem#Numerics#$kee");
    }
    $tree->entryconfigure($treeitem,-data=>$gff);  #put this little token into my coat of many pockets
    $tree->autosetmode();
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>
sub Populate_Classes {
#>>>>>>>>>>>>>>>>>>>>>>>>>>

#Purpose: To populate the tree info with class trees
#Inputs: Treeitem that called this sub
#Outputs: None
#Side effects: Populates tree

    my $treeitem=shift;
    #my $file_to_open="$registered_path\\saves\\".(split /#/,$treeitem)[1]."\\savegame.sav";
    #unless (open SAV,"<",$file_to_open) { return; }

    # get our breadcrumbs
    #my $i_hr=$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data);
    LogIt("Populating Classes: $treeitem");
    my $gff=${$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data)}{'GFF-ifo'};
    my $mod_playerlist=$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
    my @class_structs = @{$mod_playerlist->{'Fields'}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value}};
    my $i=0;
    for my $class_struct (@class_structs) {
        $tree->add($treeitem."#Class$i",
                   -text=>$classes{$class_struct->{'Fields'}[$class_struct->get_field_ix_by_label('Class')]{'Value'}},-data=>'can modify');
        $tree->add($treeitem."#Class$i#Level",
                   -text=>'Level: '.$class_struct->{'Fields'}[$class_struct->get_field_ix_by_label('ClassLevel')]{'Value'},
                   -data=>'can modify'
        );
        LogIt ("-- ".$classes{$class_struct->{'Fields'}[$class_struct->get_field_ix_by_label('Class')]{'Value'}}." Level: "
                . $class_struct->{'Fields'}[$class_struct->get_field_ix_by_label('ClassLevel')]{'Value'});
        $tree->hide('entry',$treeitem."#Class$i#Level");
        my $knownlist0_ix=$class_struct->get_field_ix_by_label('KnownList0');

        if (defined $knownlist0_ix) {
            $tree->add($treeitem."#Class$i#KnownList0",-text=>'Force Powers',-data=>'can modify');
            my @power_structs=@{$class_struct->{'Fields'}[$knownlist0_ix]{'Value'}};
            for my $power_struct (@power_structs) {
                $tree->add($treeitem."#Class$i#KnownList0#Power".$powers_full{$power_struct->{'Fields'}{'Value'}},
                           -text=>"$powers_full{$power_struct->{'Fields'}{'Value'}}",
                           -data=>'can modify');
                $tree->hide('entry',$treeitem."#Class$i#KnownList0#Power".$powers_full{$power_struct->{'Fields'}{'Value'}});
                LogIt ("--- Power: " . $powers_full{$power_struct->{'Fields'}{'Value'}});
            }
            $tree->hide('entry',$treeitem."#Class$i#KnownList0");
        }
        $i++;
    }
    $tree->autosetmode();
}

#>>>>>>>>>>>>>>>>>>>>>>>
sub Populate_Skills{
#>>>>>>>>>>>>>>>>>>>>>>>

#Purpose: To populate the tree info with skills
#Inputs: Treeitem that called this sub
#Outputs: None
#Side effects: Populates tree
    my $treeitem=shift;
    # get our breadcrumbs
    LogIt("Populating skills: $treeitem");
    my $gff=${$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data)}{'GFF-ifo'};
    my $mod_playerlist=$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];

    my @skill_list=@{$mod_playerlist->{'Fields'}[$mod_playerlist->get_field_ix_by_label('SkillList')]{'Value'}};
    my $i=0;
    for my $skill_struct (@skill_list) {
        $tree->add($treeitem."#Skill$i",-text=>"$skills{$i}: $skill_struct->{'Fields'}{'Value'}",-data=>'can modify');
        $i++;
    };
}

#>>>>>>>>>>>>>>>>>>>>>>>>
sub Populate_Feats {
#>>>>>>>>>>>>>>>>>>>>>>>>

#Purpose: To populate the tree info with skills
#Inputs: Treeitem that called this sub
#Outputs: None
#Side effects: Populates tree

    my $treeitem=shift;
    LogIt ("Populating Feats: $treeitem");
    # get our breadcrumbs
    my $gff=${$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data)}{'GFF-ifo'};
    my $mod_playerlist=$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
    my @feat_list=@{$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FeatList')]{'Value'}};
    my $i=0;
    for my $feat_struct (@feat_list) {
        $tree->add($treeitem."#Feat".$feats_full{$feat_struct->{'Fields'}{'Value'}},-text=>"$feats_full{$feat_struct->{'Fields'}{'Value'}}",-data=>'can modify');
        $tree->hide('entry',$treeitem."#Feat".$feats_full{$feat_struct->{'Fields'}{'Value'}});
        $i++;
        LogIt ("--- Feat: " . $feats_full{$feat_struct->{'Fields'}{'Value'}});
    };
    $tree->autosetmode();
}

#>>>>>>>>>>>>>>>>>>>>>>
sub Populate_NPCs{
#>>>>>>>>>>>>>>>>>>>>>>

    my $treeitem=shift;
    my $erf_sav=${$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data)}{'ERF-sav'};
    my $avail_npcs_ref=$tree->entrycget($treeitem,-data);
    my @npc_gffs;
    my @npc_names;
    #get npc gffs now
    for my $npc_num (@$avail_npcs_ref) {
        my $tmpfil=$erf_sav->export_resource_to_temp_file("AVAILNPC$npc_num.utc");
        my $npc_gff=Bioware::GFF->new();
        $npc_gff->read_gff_file($tmpfil->{'fn'});
        LogIt ("AVAILNPC$npc_num read into memory " . (-s $tmpfil->{'fn'}) ." bytes). Parsing module");
        my $strref=$npc_gff->{Main}{'Fields'}[$npc_gff->{Main}->get_field_ix_by_label('FirstName')]{'Value'}{'StringRef'};
        my $npcname;
        if ($strref == -1) {
            $npcname=$npc_gff->{Main}{'Fields'}[$npc_gff->{Main}->get_field_ix_by_label('FirstName')]{'Value'}{'Substrings'}[0]{Value};
        } else {
            $npcname=Bioware::TLK::string_from_resref($registered_path,$strref);
        }
        $tree->add($treeitem."#NPC$npc_num",-text=>$npcname,-data=>$npc_gff);
        $tree->add($treeitem."#NPC$npc_num#",-text=>'');
        $tree->hide('entry',$treeitem."#NPC$npc_num#");
    }
    $tree->autosetmode();
}

#>>>>>>>>>>>>>>>>>>>>
sub Populate_NPC{
#>>>>>>>>>>>>>>>>>>>>
    my $treeitem=shift;
    my $gff=$tree->entrycget($treeitem,-data);  #FIX THIS (CAN MODIFY)
    my $appearance     =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Appearance_Type')]{Value};
    my $portrait       =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('PortraitId')]{Value};
    my $att_str        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Str')]{Value};
    my $att_dex        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Dex')]{Value};
    my $att_con        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Con')]{Value};
    my $att_int        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Int')]{Value};
    my $att_wis        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Wis')]{Value};
    my $att_cha        =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Cha')]{Value};
    my $hitpoints      =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('HitPoints')]{Value};
    my $maxhitpoints   =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('MaxHitPoints')]{Value};
    my $min1hp         =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Min1HP')]{Value};
    my $forcepoints    =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('ForcePoints')]{Value};
    my $maxforcepoints =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('MaxForcePoints')]{Value};
    my $experience     =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Experience')]{Value};
    my $gender         =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('Gender')]{Value};
    my $goodevil       =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('GoodEvil')]{Value};
    my $skill_structs  =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('SkillList')]{Value};
    my $feat_structs   =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('FeatList')]{Value};
    my $class_structs  =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('ClassList')]{Value};
    my $soundset       =$gff->{Main}{Fields}[$gff->{Main}->get_field_ix_by_label('SoundSetFile')]{Value};

    $tree->add($treeitem."#Appearance",-text=>"Appearance: $appearance_hash{$appearance}",-data=>'can modify');
    $tree->add($treeitem."#Portrait",-text=>"Portrait: $portraits_hash{$portrait}",-data=>'can modify');
    $tree->add($treeitem."#Soundset",-text=>"Soundset: $soundset_hash{$soundset}",-data=>'can modify');
    $tree->add($treeitem."#STR",-text=>"STR: $att_str",-data=>'can modify');
    $tree->add($treeitem."#DEX",-text=>"DEX: $att_dex",-data=>'can modify');
    $tree->add($treeitem."#CON",-text=>"CON: $att_con",-data=>'can modify');
    $tree->add($treeitem."#INT",-text=>"INT: $att_int",-data=>'can modify');
    $tree->add($treeitem."#WIS",-text=>"WIS: $att_wis",-data=>'can modify');
    $tree->add($treeitem."#CHA",-text=>"CHA: $att_cha",-data=>'can modify');
    $tree->add($treeitem."#HitPoints",-text=>"HitPoints: $hitpoints",-data=>'can modify');
    $tree->add($treeitem."#MaxHitPoints",-text=>"MaxHitPoints: $maxhitpoints",-data=>'can modify');
    $tree->add($treeitem."#Min1HP",-text=>"Min1HP: $min1hp",-data=>'can modify');
    $tree->add($treeitem."#Experience",-text=>"Experience: $experience",-data=>'can modify');
    $tree->add($treeitem."#ForcePoints",-text=>"ForcePoints: $forcepoints",-data=>'can modify');
    $tree->add($treeitem."#MaxForcePoints",-text=>"MaxForcePoints: $maxforcepoints",-data=>'can modify');
    $tree->add($treeitem."#Gender",-text=>"Gender: $genders{$gender}",-data=>'can modify');
    $tree->add($treeitem."#GoodEvil",-text=>"GoodEvil: $goodevil",-data=>'can modify');
    $tree->add($treeitem."#Skills",-text=>"Skills");
    for (my $i=0; $i<=7; $i++) {
        $tree->add($treeitem."#Skills#Skill$i",
                   -text=>"$skills{$i}: " . $skill_structs->[$i]{'Fields'}{'Value'},
                   -data=>'can modify');
        $tree->hide('entry',$treeitem."#Skills#Skill$i");
    }
    $tree->add($treeitem."#Feats",-text=>"Feats",-data=>'can modify');
    for my $featstruct (@$feat_structs) {
        $tree->add($treeitem."#Feats#Feat".$feats_full{$featstruct->{'Fields'}{'Value'}},
                   -text=>$feats_full{$featstruct->{'Fields'}{'Value'}},
                   -data=>'can modify');
        $tree->hide('entry',$treeitem."#Feats#Feat".$feats_full{$featstruct->{'Fields'}{'Value'}});
    }
    $tree->add($treeitem."#Classes",-text=>"Classes");
    my $i=0;
    for my $classstruct (@$class_structs) {
        my $classname=$classes{$classstruct->{'Fields'}[0]{'Value'}};
        $tree->add($treeitem."#Classes#Class$i",-text=>$classes{$classstruct->{'Fields'}[$classstruct->get_field_ix_by_label('Class')]{'Value'}},-data=>'can modify');
        $tree->add($treeitem."#Classes#Class$i#Level",-text=>"Level: ".$classstruct->{'Fields'}[$classstruct->get_field_ix_by_label('ClassLevel')]{'Value'},-data=>'can modify');
        $tree->hide('entry',$treeitem."#Classes#Class$i");
        $tree->hide('entry',$treeitem."#Classes#Class$i#Level");
        my $knownlist0_ix=$classstruct->get_field_ix_by_label('KnownList0');
        if (defined $knownlist0_ix) {
            $tree->add($treeitem."#Classes#Class$i#KnownList0",-text=>'Force Powers',-data=>'can modify');
            my @power_structs=@{$classstruct->{'Fields'}[$knownlist0_ix]{'Value'}};
            for my $power_struct (@power_structs) {
                $tree->add($treeitem."#Classes#Class$i#KnownList0#Power".$powers_full{$power_struct->{'Fields'}{'Value'}},
                           -text=>"$powers_full{$power_struct->{'Fields'}{'Value'}}",
                           -data=>'can modify');
                $tree->hide('entry',$treeitem."#Classes#Class$i#KnownList0#Power".$powers_full{$power_struct->{'Fields'}{'Value'}});
                LogIt ("--- Power: " . $powers_full{$power_struct->{'Fields'}{'Value'}});
            }
            $tree->hide('entry',$treeitem."#Classes#Class$i#KnownList0");
        }
        $i++;
    }
    $tree->autosetmode();
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnWidgets{
#>>>>>>>>>>>>>>>>>>>>>>>>>>

# Purpose: to create/destroy widgets according to the leaf selected
# Inputs: tree item selected
# Outputs: none
# Side-effects: creates/destroys widges on side panel
    my $treeitem=shift;
    for my $widge (@spawned_widgets) {   #unspawn old widgets
        $widge->destroy if Tk::Exists($widge);
    }
    @spawned_widgets=();
    my $use_generic_widgets=join '#', ('z',qw (
    STR DEX WIS CON INT CHA HitPoints MaxHitPoints ForcePoints MaxForcePoints Experience GoodEvil Level),'z');

    my $lastleaf=(split /#/, $treeitem)[-1];
    my ($ifo_gff,$res_gff,$pty_gff,$inv_gff);

    my $root='#'.(split /#/,$treeitem)[1];
    my $datahash=$tree->entrycget($root,-data);


    if ($treeitem=~/NPCs#NPC(\d)/)
    {
        my $npcnum=$1;
        if ($datahash->{"AVAILNPC$npcnum.utc"}) {           #if we've already modified this NPC
            $ifo_gff=$datahash->{"AVAILNPC$npcnum.utc"};    #then use the modified GFF
        }
        else {                                              #otherwise, grab the original
            $treeitem=~/(.*NPCs#NPC\d)/;
            $ifo_gff=$tree->entrycget($1,-data);
        }
        if ($treeitem=~/NPCs#NPC\d$/) {                     #for the special case of changing NPC name
            my $cur_npc_name=$tree->entrycget($treeitem,-text);
            SpawnFirstNameWidgets($treeitem,$cur_npc_name,\$ifo_gff);
        }
    }
    else
    {
        $ifo_gff=$datahash->{'GFF-ifo'};
        $pty_gff=$datahash->{'GFF-pty'};
        $res_gff=$datahash->{'GFF-res'};
        $inv_gff=$datahash->{'GFF-inv'};
    }

    if    ($treeitem =~ /(.*#Globals)#Booleans/) {
        my $gbl_gff=$tree->entrycget($1,-data);
        SpawnBooleanWidgets ($treeitem,\$gbl_gff);}
    elsif ($treeitem =~ /(.*#Globals)#Numerics/) {
        my $gbl_gff=$tree->entrycget($1,-data);
        SpawnNumericWidgets ($treeitem,\$gbl_gff);}
    elsif ($lastleaf eq 'Feats') {
        SpawnAddFeatWidgets ($treeitem,\$ifo_gff); }
    elsif ($lastleaf eq 'Appearance') {
        SpawnAppearanceWidgets ($treeitem,\$ifo_gff); }
    elsif ($lastleaf eq 'Portrait') {
        SpawnPortraitWidgets ($treeitem,\$ifo_gff); }
    elsif ($lastleaf eq 'Soundset') {
        SpawnSoundsetWidgets ($treeitem,\$ifo_gff); }
    elsif ($lastleaf eq 'KnownList0') {
        SpawnAddPowerWidgets ($treeitem,\$ifo_gff); }
    elsif ($use_generic_widgets=~/#$lastleaf#/) {
        ($tree->entrycget($treeitem,-text)) =~ /: (.*)/;
        SpawnGenericWidgets ($treeitem,$lastleaf,$1,\$ifo_gff) }
    elsif ($lastleaf=~/Class/) {
        SpawnChangeClassWidgets ($treeitem,\$ifo_gff); }
    elsif ($lastleaf=~/Feat/) {
        my $current_feat=$tree->entrycget($treeitem,-text);
        SpawnFeatWidgets ($treeitem,$current_feat,\$ifo_gff) }
    elsif ($lastleaf=~/Skill/) {
        ($tree->entrycget($treeitem,-text))=~/(.*): (.*)/;
        SpawnSkillWidgets ($treeitem,$1,$2,\$ifo_gff) }
    elsif ($lastleaf=~/Power/) {
        my $current_power=$tree->entrycget($treeitem,-text);
        SpawnPowerWidgets ($treeitem,$current_power,\$ifo_gff) }
    elsif ($lastleaf eq 'Gender') {
        ($tree->entrycget($treeitem,-text)) =~ /: (.*)/;
        SpawnGenderWidgets ($treeitem,$1,\$ifo_gff) }
    elsif ($lastleaf eq 'Credits') {
        ($tree->entrycget($treeitem,-text)) =~ /(.*): (.*)/;
        SpawnPartyWidgets  ($treeitem,$1,$2,\$pty_gff) }
    elsif ($lastleaf eq 'PartyXP') {
        ($tree->entrycget($treeitem,-text)) =~ /(.*): (.*)/;
        SpawnPartyWidgets  ($treeitem,$1,$2,\$pty_gff) }
    elsif ($lastleaf eq 'SaveGameName') {
        ($tree->entrycget($treeitem,-text)) =~ /: (.*)/;
        SpawnSaveGameNameWidgets  ($treeitem,$1,\$res_gff) }
    elsif ($lastleaf eq 'FirstName') {
        ($tree->entrycget($treeitem,-text)) =~ /: (.*)/;
        SpawnFirstNameWidgets  ($treeitem,$1,\$ifo_gff) }
    elsif ($lastleaf eq 'TimePlayed') {
        ($tree->entrycget($treeitem,-text)) =~ /(\d+)h (\d+)m (\d+)/;
        SpawnTimePlayedWidgets ($treeitem,$1,$2,$3,\$res_gff) }
    elsif (($lastleaf eq 'CheatUsed') || ($lastleaf eq 'Min1HP')) {
        ($tree->entrycget($treeitem,-text)) =~ /: (\d)/;
        SpawnCheatWidgets ($treeitem,$1,\$res_gff,\$pty_gff,\$ifo_gff); }
    elsif ($treeitem =~/#Inventory$/) {
        SpawnAddInventoryWidgets($treeitem,\$inv_gff); }
    elsif ($treeitem =~/#Inventory#/) {
        SpawnInventoryWidgets($treeitem,\$inv_gff);
    }


}
#>>>>>>>>>>>>>>>>>>>
sub CommitChanges {
#>>>>>>>>>>>>>>>>>>>

    my $treeitem=shift;

# retrieve all of our files except NPC .utc
    my $root='#'.(split /#/,$treeitem)[1];
    my $datahash=$tree->entrycget($root,-data);
    my $erf_sav=$datahash->{'ERF-sav'};
    my $erf_mod=$datahash->{'ERF-mod'};
    my $ifo_gff=$datahash->{'GFF-ifo'};
    my $pty_gff=$datahash->{'GFF-pty'};
    my $res_gff=$datahash->{'GFF-res'};
    my $inv_gff=$datahash->{'GFF-inv'};
    my $gbl_gff=$tree->entrycget("$root#Globals",-data);
    $mw->Busy(-recurse=>1);

    my $gamedir=(split /#/,$treeitem)[1];
    LogIt ("Committing changes for $gamedir");

# write PARTYTABLE.res
    my $fn="$registered_path\\saves\\$gamedir\\PARTYTABLE.res";
    my $tot_pty_written=$pty_gff->write_gff_file($fn);
    if ($tot_pty_written==0) { die "Could not write to $registered_path\\saves\\$gamedir\\PARTYTABLE.res" }
    LogIt ("Partytable updated. $tot_pty_written bytes written.");

# write savenfo.res
    my $fn2="$registered_path\\saves\\$gamedir\\savenfo.res";
    my $tot_res_written=$res_gff->write_gff_file($fn2);
    if ($tot_res_written==0) { die "Could not write to $registered_path\\saves\\$gamedir\\savenfo.res" }
    LogIt ("Savenfo updated. $tot_res_written bytes written.");

# write GLOBALVARS.res
    if (ref $gbl_gff eq 'Bioware::GFF') {
       my $fn2a="$registered_path\\saves\\$gamedir\\GLOBALVARS.res";
       my $tot_gbl_written=$gbl_gff->write_gff_file($fn2a);
       if ($tot_gbl_written==0) { die "Could not write to $registered_path\\saves\\$gamedir\\GLOBALVARS.res" }
       LogIt ("GLOBALVARS.res updataed.  $tot_gbl_written bytes written.");
    }

# write Module.ifo to tempfile
    my $tmpfil=Win32API::File::Temp->new();
    unless (my $tmp=$ifo_gff->write_gff_file($tmpfil->{'fn'})) {
        die "Could not write module.ifo to temp file.";
    }

# write INVENTORY.res to tempfile
    my $tmpfil_inv=Win32API::File::Temp->new();
    unless (my $tmp=$inv_gff->write_gff_file($tmpfil_inv->{'fn'})) {
        die "Could not write INVENTORY.res to temp file.";
    }

# populate the erf_mod with its original data
    unless (my $tmp=$erf_mod->load_erf()) {
        die "Failed to read in last module of savegame.";
    }

# insert into erf_mod the new module.ifo file
    unless (my $tmp=$erf_mod->import_resource($tmpfil->{'fn'},'Module.ifo')) {
        die "Failed to import Module.ifo into last module of savegame";
    }


# write the erf_mod to tempfile
    my $tmpfil2=Win32API::File::Temp->new();
    unless (my $tmp=$erf_mod->write_erf($tmpfil2->{'fn'})) {
        die "Failed to write last module to temp file.";
    }

# load the original erf_sav
    unless (my $tmp=$erf_sav->load_erf()) {
        die "Failed to read in main savegame data";
    }

# insert into erf_sav the new erf_mod file
    unless (my $tmp=$erf_sav->import_resource($tmpfil2->{'fn'},$erf_mod->{'modulename'})) {
        die "Failed to import last module of savegame into main savegame data.";
    }

# insert into erf_sav the new INVENTORY.res file
    unless (my $tmp=$erf_sav->import_resource($tmpfil_inv->{'fn'},'INVENTORY.res')) {
        die "Failed to import INVENTORY.res into main savegame data.";
    }

# insert into the erf_sav any NPC file
    for (my $i=0; $i<10; $i++) {
        my $utcname="AVAILNPC$i.utc";
        if ($datahash->{$utcname}) {
            my $utc_gff=$datahash->{$utcname};
            LogIt "Writing $utcname";
            my $tmpfil=Win32API::File::Temp->new();
            unless (my $tmp=$utc_gff->write_gff_file($tmpfil->{'fn'})) {
                die "Failed to write $utcname to tempfile";
            }
            unless (my $tmp=$erf_sav->import_resource($tmpfil->{'fn'},$utcname)) {
                die "Failed to import $utcname into main savegame data.";
            }
        }
    }

# if PC.utc exists in datahash, write it also
    my $utcname="PC.utc";
    if ($datahash->{$utcname}) {
        my $utc_gff=$datahash->{$utcname};
        LogIt "Writing $utcname";
        my $tmpfil=Win32API::File::Temp->new();
        unless (my $tmp=$utc_gff->write_gff_file($tmpfil->{'fn'})) {
            die "Failed to write PC.utc to tempfile";
        }
        unless (my $tmp=$erf_sav->import_resource($tmpfil->{'fn'},$utcname)) {
            die "Failed to import PC.utc to tempfile";
        }
    }




# write new erf_sav
    my $total_written;
    unless ($total_written=$erf_sav->write_erf("$registered_path\\saves\\$gamedir\\savegame.sav")) {
        die "Could not write to $registered_path\\saves\\$gamedir\\savegame.sav"
    }
    LogIt("$registered_path\\saves\\$gamedir\\savegame.sav written ($total_written bytes total)");

    $mw->Unbusy;

    $mw->Dialog(-title=>'Save Successful',-text=>"File $registered_path\\saves\\$gamedir\\savegame.sav saved successfully.",-font=>['MS Sans Serif','8'],-buttons=>['Ok'])->Show();
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnFeatWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_feat,$ifo_gff_ref)=@_;
    if ($treeitem =~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }
    my $lbl=$mw->Label(-text=>"Feat: $cur_feat",-font=>['MS Sans Serif','8'])->place(-relx=>800/$x,-rely=>200/$y,-anchor=>'ne');
    push @spawned_widgets,$lbl;
    my %revhash=reverse %feats_full;

    my $featvalue= $revhash{$cur_feat};
    my $btn=$mw->Button(-text=>"Remove Feat",-command=>sub {
        unless ($tree->info('exists',$treeitem)) {return;}
        LogIt("Removing feat: $cur_feat");
        if ($treeitem=~/NPCs/) {
            my $featlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('FeatList')];
            my $featlist_structs=$featlist->{Value};
            my @new_featlist_structs=();

            for my $this_struct (@$featlist_structs) {
                unless ($this_struct->{Fields}{Value} == $featvalue) {
                    push @new_featlist_structs,$this_struct;
                }
            }
            $featlist->{Value}=[@new_featlist_structs];                   #perform feat removal on NPC
            my $root='#'.(split /#/,$treeitem)[1];                        # store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);

        } else {
            my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            my $featlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FeatList')];
            my $featlist_structs=$featlist->{Value};
            my @new_featlist_structs=();
            for my $this_struct (@$featlist_structs) {
                unless ($this_struct->{Fields}{Value} == $featvalue) {
                    push @new_featlist_structs,$this_struct;
                }
            }
            $featlist->{Value}=[@new_featlist_structs];                   #perform feat removal on PC
        }
        $tree->delete('entry',$treeitem);
    }
    )->place(-relx=>600/$x,-rely=>520/$y);
    push @spawned_widgets,$btn;

    my $btn3=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn3;
}

#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnAddFeatWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$ifo_gff_ref)=@_;

    my %revhash=$short_or_long ? reverse %feats_full : reverse %feats_short;

    if ($treeitem =~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl=$mw->Label(-text=>"Available Feats:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>100/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    #my $featlist= $mw->Scrolled('Listbox',
    my $featlist= $mw->Scrolled('TList',
                                -scrollbars=>'osoe',
                                -background=>'white',
                                -selectforeground=>'#FFFFFF',
                                -selectbackground=>'#D07000',
                                -selectmode=>'extended',
                                -itemtype=>'text',
                                -orient=>'horizontal'
    )->place(-relx=>600/$x,-rely=>100/$y,-relwidth=>270/$x,-relheight=>400/$y);

    my $newstyle = $mw->ItemStyle('text',-foreground=>'#9090FF',-selectforeground=>'#D0D0FF',-selectbackground=>'#D07000');
    my @treepath=split /#/, $treeitem;  pop @treepath;  my $newtreepath=join '#',@treepath;
    for (sort keys %revhash) {
        if ($tree->info('exists',"$newtreepath#Feats#Feat".$_)) {
            $featlist->insert('end',-text=>$_,-style=>$newstyle);
        }
        else {
            $featlist->insert('end',-text=>$_);
        }
    }
    #$featlist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $featlist;

    my $btn2=$mw->Button(-text=>"Add New Feat",-command=>sub {
        #my @selected_indices=$featlist->curselection;
        my @selected_indices=$featlist->info('selection');
        unless (scalar @selected_indices) { return; }  #nothing selected
        #if ($cur_list_index eq '' ) { return; } #nothing selected
        my @treepath=split /#/, $treeitem;  pop @treepath;  my $newtreepath=join '#',@treepath;
        for my $selected_index (@selected_indices) {
            my $selected_feat=$featlist->entrycget($selected_index,-text);
          # $newtreepath .="#Feats#Feat" . $featlist->get($cur_list_index);
            next if ($tree->info('exists',"$newtreepath#Feats#Feat$selected_feat"));
            my $featvalue2=$revhash{$selected_feat};
            LogIt ("Adding feat: $selected_feat");
            if ($treeitem=~/NPCs/) {
                my $featlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('FeatList')];
                my $featlist_structs=$featlist->{Value};
                my $new_feat=Bioware::GFF::Struct->new('ID'=>1);
                $new_feat->createField('Type'=>FIELD_WORD,'Label'=>'Feat','Value'=>$featvalue2);
                push @$featlist_structs,$new_feat;                            #add the feat

                my $root='#'.(split /#/,$treeitem)[1];                        # store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;
                my $temp=$1;                                                  #so we know that it needs replacing
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);   }
            else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                my $featlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FeatList')];
                my $featlist_structs=$featlist->{Value};
                my $new_feat=Bioware::GFF::Struct->new('ID'=>1);
                $new_feat->createField('Type'=>FIELD_WORD,'Label'=>'Feat','Value'=>$featvalue2);
                push @$featlist_structs,$new_feat;                            #add the feat
            }
            LogIt ("Successful.");
            $tree->add("$newtreepath#Feats#Feat$selected_feat",
                       -text=>$selected_feat,-data=>'can modify');
            $featlist->entryconfigure($selected_index,-style=>$newstyle);
        }
    }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>80/$x);
    push @spawned_widgets,$btn2;

    my $btn3=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) }
    )->place(-relx=>776/$x,-rely=>520/$y);

    push @spawned_widgets,$btn3;

    my $btn4=$mw->Button(-text=>"Remove Feats",-command=>sub {
        my @selected_indices=$featlist->info('selection');
        unless (scalar @selected_indices) { return; }  #nothing selected
        my @treepath=split /#/, $treeitem;  pop @treepath;  my $newtreepath=join '#',@treepath;
        for my $selected_index (@selected_indices) {
            my $selected_feat=$featlist->entrycget($selected_index,-text);
            next unless ($tree->info('exists',"$newtreepath#Feats#Feat$selected_feat"));
            my $featvalue2=$revhash{$selected_feat};
            LogIt ("Removing feat: $selected_feat");
            if ($treeitem=~/NPCs/) {
                my $featlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('FeatList')];
                my $featlist_structs=$featlist->{Value};
                my @new_featlist_structs=();

                for my $this_struct (@$featlist_structs) {
                    unless ($this_struct->{Fields}{Value} == $featvalue2) {
                        push @new_featlist_structs,$this_struct;
                    }
                }
                $featlist->{Value}=[@new_featlist_structs];                   #perform feat removal on NPC
                my $root='#'.(split /#/,$treeitem)[1];                        # store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                my $temp=$1;
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash); }
            else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                my $featlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FeatList')];
                my $featlist_structs=$featlist->{Value};
                my @new_featlist_structs=();
                for my $this_struct (@$featlist_structs) {
                    unless ($this_struct->{Fields}{Value} == $featvalue2) {
                        push @new_featlist_structs,$this_struct;
                    }
                }
                $featlist->{Value}=[@new_featlist_structs];                   #perform feat removal on PC
            }
            LogIt ("Successful.");
            $tree->delete('entry',"$newtreepath#Feats#Feat$selected_feat");
            $featlist->entryconfigure($selected_index,-style=>'');
        }
                          }
    )->place(-relx=>688/$x,-rely=>520/$y,-relwidth=>80/$x);
    push @spawned_widgets,$btn4;

    my $chkbtn=$mw->Checkbutton(-text=>'Show all feats/powers',
                 -variable=>\$short_or_long,
                 -command=> sub {
                    %revhash=$short_or_long ? reverse %feats_full : reverse %feats_short;
                    $featlist->delete(0,'end');
                    for (sort keys %revhash) {
                        if ($tree->info('exists',"$newtreepath#Feats#Feat".$_)) {
                            $featlist->insert('end',-text=>$_,-style=>$newstyle); }
                        else {
                            $featlist->insert('end',-text=>$_);
                        }
                    }
                 }
                )->place(-relx=>590/$x,-rely=>590/$y, -anchor=>'sw');
    push @spawned_widgets,$chkbtn;
}

#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnSkillWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_skill,$cur_rank,$ifo_gff_ref)=@_;
    if ($treeitem =~ /NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }
    my $lbl=$mw->Label(-text=>"Skill: $cur_skill",-font=>['MS Sans Serif','12'])->place(-relx=>810/$x,-rely=>200/$y,-anchor=>'ne');
    push @spawned_widgets,$lbl;
    my $new_rank=$cur_rank;
    my $txt=$mw->Entry(-textvariable=>\$new_rank,-background=>'white')->place(-relx=>820/$x,-rely=>200/$y,-relwidth=>30/$x);
    push @spawned_widgets,$txt;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $tree->entryconfigure($treeitem,-text=>"$cur_skill: $new_rank");
            LogIt("Changing $cur_skill rank to $new_rank");
            my $treeitem2=$treeitem;
            my $skillnumber=chop $treeitem2;
            if ($treeitem=~/NPCs/) {
                $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('SkillList')]{Value}[$skillnumber]{Fields}{Value}=$new_rank;
                my $root='#'.(split /#/,$treeitem)[1];                        #store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                my $temp=$1;
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
            } else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('SkillList')]{Value}[$skillnumber]{Fields}{Value}=$new_rank;
            }
        }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnPowerWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_power,$ifo_gff_ref)=@_;

    if ($treeitem =~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl=$mw->Label(-text=>"Power: $cur_power",-font=>['MS Sans Serif','8'])->place(-relx=>800/$x,-rely=>200/$y,-anchor=>'ne');
    push @spawned_widgets,$lbl;

    my %revhash=reverse %powers_full;
    my $powervalue= $revhash{$cur_power};

    my $btn=$mw->Button(-text=>"Remove Power",-command=>sub {
        unless ($tree->info('exists',$treeitem)) { return;}
        $treeitem=~/#Class(\d)#/;
        my $classindex=$1;
        LogIt ("Removing power: $cur_power");

        if ($treeitem=~/NPCs/) {
            $treeitem=~/Class(\d)/;
            my $classnumber=$1;

            my $classlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{Value};
            my $cur_class=$classlist->[$classnumber];
            my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
            unless (defined $knownlist_ix) { LogIt ("Failed to remove power");  return; }
            my $powerlist=$cur_class->{Fields}[$knownlist_ix];
            my $powerlist_structs=$powerlist->{Value};
            my @new_powerlist_structs=();

            for my $this_struct (@$powerlist_structs) {
                unless ($this_struct->{Fields}{Value} == $powervalue) {
                    push @new_powerlist_structs,$this_struct;
                }
            }
            $powerlist->{Value}=[@new_powerlist_structs];                 #perform power removal on NPC
            my $root='#'.(split /#/,$treeitem)[1];                        #and if successful, store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);
        } else {
            my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            my $classlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value};
            my $cur_class=$classlist->[$classindex];
            my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
            unless (defined $knownlist_ix) { LogIt ("Failed to remove power");  return; }
            my $powerlist=$cur_class->{Fields}[$knownlist_ix];
            my $powerlist_structs=$powerlist->{Value};
            my @new_powerlist_structs=();
            for my $this_struct (@$powerlist_structs) {
                unless ($this_struct->{Fields}{Value} == $powervalue) {
                    push @new_powerlist_structs,$this_struct;
                }
            }
            $powerlist->{Value}=[@new_powerlist_structs];                 #perform power removal on PC
        }
        $tree->delete('entry',$treeitem);
        LogIt ("Power removed succesfully.");
    }
    )->place(-relx=>600/$x,-rely=>520/$y);
    push @spawned_widgets,$btn;

    my $btn3=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn3;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnAddPowerWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$ifo_gff_ref)=@_;

    my %revhash=$short_or_long ? reverse %powers_full : reverse %powers_short;
    if ($treeitem =~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
       push @spawned_widgets,$lbl_npc;
    }

    my $lbl=$mw->Label(-text=>"Available Powers:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>100/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;
    #my $powerlist= $mw->Scrolled('Listbox',
    my $powerlist= $mw->Scrolled('TList',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#A000C0',
                                 -selectmode=>'extended',
                                 -itemtype=>'text',
                                 -orient=>'horizontal'
    )->place(-relx=>600/$x,-rely=>100/$y,-relwidth=>270/$x,-relheight=>400/$y);

    my $newstyle = $mw->ItemStyle('text',-foreground=>'#9090FF',-selectforeground=>'#FFFF00',-selectbackground=>'#A000C0');
    my @treepath=split /#/, $treeitem;  pop @treepath;  my $newtreepath=join '#',@treepath;

    for (sort keys %revhash) {
        if ($tree->info('exists',"$newtreepath#KnownList0#Power".$_)) {
            $powerlist->insert('end',-text=>$_,-style=>$newstyle);
        }
        else {
            $powerlist->insert('end',-text=>$_);
        }
    }
    #$powerlist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $powerlist;

    my $btn2=$mw->Button(-text=>"Add New Power",-command=>sub {
        my @selected_indices=$powerlist->info('selection');
        #my @selected_indices=$powerlist->curselection;
        return unless (scalar @selected_indices); #nothing selected
        my @treepath=split /#/, $treeitem; pop @treepath; my $newtreepath=join '#',@treepath;
        for my $selected_index (@selected_indices) {
            my $selected_power=$powerlist->entrycget($selected_index,-text);
            #$newtreepath .= "#KnownList0#Power".($powerlist->get($cur_list_index));
            $treeitem=~/#Class(\d)#/;
            my $classindex=$1;
            next if ($tree->info('exists',"$newtreepath#KnownList0#Power$selected_power"));
            my $powervalue2=$revhash{$selected_power};
            LogIt ("Adding power: $selected_power");
            if ($treeitem=~/NPCs/) {
                $treeitem=~/Class(\d)/;
                my $classnumber=$1;
                my $classlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{Value};
                my $cur_class=$classlist->[$classnumber];
                my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
                unless (defined $knownlist_ix) { LogIt ("Failed to add power");  next; }
                my $powerlist_=$cur_class->{Fields}[$knownlist_ix];
                my $powerlist_structs=$powerlist_->{Value};
                my $new_power=Bioware::GFF::Struct->new('ID'=>3);
                $new_power->createField('Type'=>FIELD_WORD,'Label'=>'Spell','Value'=>$powervalue2);
                push @$powerlist_structs,$new_power;                            #add the power
                my $root='#'.(split /#/,$treeitem)[1];                        #and if successful, store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                my $temp=$1;
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
            } else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                my $classlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value};
                my $cur_class=$classlist->[$classindex];
                my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
                unless (defined $knownlist_ix) { LogIt ("Failed to add power");  next; }
                my $powerlist_=$cur_class->{Fields}[$knownlist_ix];
                my $powerlist_structs=$powerlist_->{Value};
                my $new_power=Bioware::GFF::Struct->new('ID'=>3);
                $new_power->createField('Type'=>FIELD_WORD,'Label'=>'Spell','Value'=>$powervalue2);
                push @$powerlist_structs,$new_power;                            #add the power
            }
            LogIt ("Successful.");
            $tree->add("$newtreepath#KnownList0#Power$selected_power",
                       -text=>$selected_power,-data=>'can modify');
            $powerlist->entryconfigure($selected_index,-style=>$newstyle);
        }
    } )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>90/$x);
    push @spawned_widgets,$btn2;

    my $btn3=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>796/$x,-rely=>520/$y,-relwidth=>90/$x);
    push @spawned_widgets,$btn3;

    my $btn4=$mw->Button(-text=>"Remove Powers",-command=>sub {

        my @selected_indices=$powerlist->info('selection');
        unless (scalar @selected_indices) { return; }  #nothing selected
        my @treepath=split /#/, $treeitem;  pop @treepath;  my $newtreepath=join '#',@treepath;
        for my $selected_index (@selected_indices) {
            my $selected_power=$powerlist->entrycget($selected_index,-text);
            $treeitem=~/#Class(\d)#/;
            my $classindex=$1;
            next unless ($tree->info('exists',"$newtreepath#KnownList0#Power$selected_power"));
            my $powervalue2=$revhash{$selected_power};
            LogIt ("Removing power: $selected_power");
            if ($treeitem=~/NPCs/) {
                $treeitem=~/Class(\d)/;
                my $classnumber=$1;

                my $classlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{Value};
                my $cur_class=$classlist->[$classnumber];
                my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
                unless (defined $knownlist_ix) { LogIt ("Failed to remove power");  next; }
                my $powerlist_=$cur_class->{Fields}[$knownlist_ix];
                my $powerlist_structs=$powerlist_->{Value};
                my @new_powerlist_structs=();

                for my $this_struct (@$powerlist_structs) {
                    unless ($this_struct->{Fields}{Value} == $powervalue2) {
                        push @new_powerlist_structs,$this_struct;
                    }
                }
                $powerlist_->{Value}=[@new_powerlist_structs];                 #perform power removal on NPC
                my $root='#'.(split /#/,$treeitem)[1];                        #and if successful, store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                my $temp=$1;
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
            } else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                my $classlist=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value};
                my $cur_class=$classlist->[$classindex];
                my $knownlist_ix=$cur_class->get_field_ix_by_label('KnownList0');
                unless (defined $knownlist_ix) { LogIt ("Failed to remove power"); next; }
                my $powerlist_=$cur_class->{Fields}[$knownlist_ix];
                my $powerlist_structs=$powerlist->{Value};
                my @new_powerlist_structs=();
                for my $this_struct (@$powerlist_structs) {
                    unless ($this_struct->{Fields}{Value} == $powervalue2) {
                        push @new_powerlist_structs,$this_struct;
                    }
                }
                $powerlist_->{Value}=[@new_powerlist_structs];                 #perform power removal on PC
            }
            $tree->delete('entry',"$newtreepath#KnownList0#Power$selected_power");
            $powerlist->entryconfigure($selected_index,-style=>'');
            LogIt ("Power removed succesfully.");
        }
    })->place(-relx=>698/$x,-rely=>520/$y,-relwidth=>90/$x);
    push @spawned_widgets,$btn4;


    my $chkbtn=$mw->Checkbutton(-text=>'Show all feats/powers',
                 -variable=>\$short_or_long,
                 -command=> sub {
                    %revhash=$short_or_long ? reverse %powers_full : reverse %powers_short;
                    $powerlist->delete(0,'end');
                    for (sort keys %revhash) {
                        if ($tree->info('exists',"$newtreepath#KnownList0#Power".$_)) {
                            $powerlist->insert('end',-text=>$_,-style=>$newstyle); }
                        else {
                            $powerlist->insert('end',-text=>$_);
                        }
                    }
                 }
                )->place(-relx=>590/$x,-rely=>590/$y, -anchor=>'sw');
    push @spawned_widgets,$chkbtn;
}

#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnGenericWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_trait,$cur_rank,$ifo_gff_ref)=@_;

    my %traithash=('STR'=>'Str',
                   'DEX'=>'Dex',
                   'INT'=>'Int',
                   'WIS'=>'Wis',
                   'CON'=>'Con',
                   'CHA'=>'Cha');

    unless (exists $traithash{$cur_trait}) { $traithash{$cur_trait}=$cur_trait }  #this is so our cur_trait matches up with the appropriate GFF label
    if ($treeitem =~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl=$mw->Label(-text=>"$cur_trait",-font=>['MS Sans Serif','12'])->place(-relx=>760/$x,-rely=>200/$y,-anchor=>'ne');
    push @spawned_widgets,$lbl;
    my $new_rank=$cur_rank;
    my $txt=$mw->Entry(-textvariable=>\$new_rank,-background=>'white',-width=>9)->place(-relx=>770/$x,-rely=>200/$y);
    push @spawned_widgets,$txt;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
        $tree->entryconfigure($treeitem,-text=>"$cur_trait: $new_rank");
        LogIt ("Changing $cur_trait value to $new_rank  using field # $traithash{$cur_trait}");
        if ($treeitem=~/NPCs/) {
            if ( $cur_trait eq 'Level') {
                $treeitem=~/Class(\d)/;
                my $classnumber=$1;
                my $class_struct=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{Value}[$classnumber];
                $class_struct->{Fields}[$class_struct->get_field_ix_by_label('ClassLevel')]{Value}=$new_rank; }
            else {
                $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label($traithash{$cur_trait})]{Value}=$new_rank;
                if ($cur_trait eq 'ForcePoints') {
                    $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('CurrentForce')]{Value}=$new_rank;
                } elsif ($cur_trait eq 'HitPoints') {
                    $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('CurrentHitPoints')]{Value}=$new_rank;
                }
            }
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);
        } else {
            my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            if ($cur_trait eq 'Level') {
                $treeitem =~ /#Class(\d)#Level/;
                my $classnumber=$1;
                my $class_struct=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value}[$classnumber];
                $class_struct->{Fields}[$class_struct->get_field_ix_by_label('ClassLevel')]{Value}=$new_rank; }
            else {
                $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label($traithash{$cur_trait})]{Value}=$new_rank;
                if ($cur_trait eq 'ForcePoints') {
                    $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('CurrentForce')]{Value}=$new_rank;
                } elsif ($cur_trait eq 'HitPoints') {
                    $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('CurrentHitPoints')]{Value}=$new_rank;
                }
            }
        }
     }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>90/$x);


    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnPartyWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_trait,$cur_rank,$pty_gff_ref)=@_;
    my %traithash = ('Credits'=>'PT_GOLD', 'Party XP'=>'PT_XP_POOL');
    my $lbl=$mw->Label(-text=>"$cur_trait",-font=>['MS Sans Serif','12'])->place(-relx=>760/$x,-rely=>200/$y,-anchor=>'ne');
    push @spawned_widgets,$lbl;
    my $new_rank=$cur_rank;
    my $txt=$mw->Entry(-textvariable=>\$new_rank,-background=>'white',-width=>9)->place(-relx=>770/$x,-rely=>200/$y);
    push @spawned_widgets,$txt;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $tree->entryconfigure($treeitem,-text=>"$cur_trait: $new_rank");
            LogIt ("Changing $cur_trait to $new_rank");
            $$pty_gff_ref->{Main}{Fields}[$$pty_gff_ref->{Main}->get_field_ix_by_label($traithash{$cur_trait})]{Value}=$new_rank;
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnSaveGameNameWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$cur_savegamename,$res_gff_ref)=@_;

    my $lbl=$mw->Label(-text=>"Savegame Name",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;
    my $new_savegamename=$cur_savegamename;
    my $txt=$mw->Entry(-textvariable=>\$new_savegamename,-background=>'white',-width=>20)->place(-relx=>690/$x,-rely=>200/$y);
    push @spawned_widgets,$txt;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $tree->entryconfigure($treeitem,-text=>"Savegame Name: $new_savegamename");
            LogIt("Changing savegamename to $new_savegamename");
            $$res_gff_ref->{Main}{Fields}[$$res_gff_ref->{Main}->get_field_ix_by_label('SAVEGAMENAME')]{'Value'}=$new_savegamename;
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnFirstNameWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$cur_name,$ifo_gff_ref)=@_;


    if ($treeitem=~/NPCs/) {
        my $lbl_npc=$mw->Label(-text=>"-- $cur_name --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
        my $lbl=$mw->Label(-text=>"NPC Name",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
        push @spawned_widgets,$lbl;
    } else {
        my $lbl=$mw->Label(-text=>"Player Name",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
        push @spawned_widgets,$lbl;
    }

    my $new_playername=$cur_name;
    my $txt=$mw->Entry(-textvariable=>\$new_playername,-background=>'white',-width=>20)->place(-relx=>690/$x,-rely=>200/$y);
    push @spawned_widgets,$txt;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
        if ($treeitem=~/NPCs/) {
            LogIt ("Changing NPC name from $cur_name to $new_playername");
            $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('FirstName')]{Value}{StringRef}=-1;
            $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('FirstName')]{Value}{Substrings}[0]{Value}=$new_playername;
            $tree->entryconfigure($treeitem,-text=>"$new_playername");
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#NPC(\d)/;                                    #so we know that it needs replacing
            my $npcnum=$1;                                                #when it comes time to commit changes
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);

        } else {
            LogIt ("Changing player name to $new_playername");
            my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FirstName')]{Value}{StringRef}=-1;
            $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('FirstName')]{Value}{Substrings}[0]{Value}=$new_playername;
            $tree->entryconfigure($treeitem,-text=>"Player Name: $new_playername");
        }
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnTimePlayedWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$hours,$minutes,$seconds,$res_gff_ref)=@_;
    my $lbl=$mw->Label(-text=>"Time played",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $new_hours=$hours;
    my $txth=$mw->Entry(-textvariable=>\$new_hours,-background=>'white')->place(-relx=>690/$x,-rely=>200/$y,-relwidth=>30/$x);
    push @spawned_widgets,$txth;

    my $lblh=$mw->Label(-text=>"h",-font=>['MS Sans Serif','8'])->place(-relx=>715/$x,-rely=>200/$y,-relwidth=>10/$x);
    push @spawned_widgets,$lblh;

    my $new_minutes=$minutes;
    my $txtm=$mw->Entry(-textvariable=>\$new_minutes,-background=>'white')->place(-relx=>730/$x,-rely=>200/$y,-relwidth=>20/$x);
    push @spawned_widgets,$txtm;

    my $lblm=$mw->Label(-text=>"m",-font=>['MS Sans Serif','8'])->place(-relx=>755/$x,-rely=>200/$y,-relwidth=>10/$x);
    push @spawned_widgets,$lblm;

    my $new_seconds=$seconds;
    my $txts=$mw->Entry(-textvariable=>\$new_seconds,-background=>'white')->place(-relx=>770/$x,-rely=>200/$y,-relwidth=>20/$x);
    push @spawned_widgets,$txts;

    my $lbls=$mw->Label(-text=>"s",-font=>['MS Sans Serif','8'])->place(-relx=>795/$x,-rely=>200/$y,-relwidth=>10/$x);
    push @spawned_widgets,$lbls;


    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            my $newtime=$new_seconds+(60*$new_minutes)+(3600*$new_hours);
            $tree->entryconfigure($treeitem,-text=>'Time Played: '.
                                                               (sprintf "%uh ",($newtime/3600)).
                                                               (sprintf "%um ",(($newtime % 3600)/60)).
                                                               (sprintf "%us",($newtime % 60)));
            LogIt("Chaning time played to $newtime");
            $$res_gff_ref->{Main}{Fields}[$$res_gff_ref->{Main}->get_field_ix_by_label('TIMEPLAYED')]{Value}=$newtime;
        }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnCheatWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$cheatval,$res_gff_ref,$pty_gff_ref,$ifo_gff_ref)=@_;
    my $lbl;
    if ($treeitem =~ /Cheat/) {
        $lbl=$mw->Label(-text=>"Cheats Used",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw'); }
    else {
        if ($treeitem =~/NPCs/) {
            $treeitem=~/(.*#NPCs#.*?)#/;
            my $npcname=$tree->entrycget($1,-text);
            my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
            push @spawned_widgets,$lbl_npc;
        }

        $lbl=$mw->Label(-text=>"Min 1 HP",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    }
    push @spawned_widgets,$lbl;

    my $new_cheatval=$cheatval;
    my $r_on=$mw->Radiobutton(-text=>"Yes",-variable=>\$new_cheatval,-value=>'1',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>220/$y);
    my $r_off=$mw->Radiobutton(-text=>"No",-variable=>\$new_cheatval,-value=>'0',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>250/$y);
    push @spawned_widgets,($r_on,$r_off);

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            if ($treeitem =~/Cheat/) {
                $tree->entryconfigure($treeitem,-text=>"Cheats Used: $new_cheatval");
                LogIt("Changing cheat flag to $new_cheatval");
                $$res_gff_ref->{Main}{Fields}[$$res_gff_ref->{Main}->get_field_ix_by_label('CHEATUSED')]{Value}=$new_cheatval;
                $$pty_gff_ref->{Main}{Fields}[$$pty_gff_ref->{Main}->get_field_ix_by_label('PT_CHEAT_USED')]{Value}=$new_cheatval; }
            else {
                $tree->entryconfigure($treeitem,-text=>"Min1HP: $new_cheatval");
                LogIt("Changing Min1HP flag to $new_cheatval");
                if ($treeitem=~/NPCs/) {
                    $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Min1HP')]{Value}=$new_cheatval;
                    my $root='#'.(split /#/,$treeitem)[1];                        #store the new
                    my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                    $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                    my $temp=$1;
                    my $npcnum=chop $temp;                                        #when it comes time to commit changes
                    $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                    $tree->entryconfigure($root,-data=>$datahash);
                    }
                else {
                    my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                    $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Min1HP')]{Value}=$new_cheatval;
                }
            }
                })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnBooleanWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$gbl_gff_ref)=@_;

    my $treetext=$tree->entrycget($treeitem,-text);
    $treetext =~ /(.*): (.*)/;
    my $lbltext=$1; my $curval=$2;
    my $lbl=$mw->Label(-text=>"Global Boolean: $lbltext",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;


    my $r_on=$mw->Radiobutton(-text=>"Yes",-variable=>\$curval,-value=>'1',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>220/$y);
    my $r_off=$mw->Radiobutton(-text=>"No",-variable=>\$curval,-value=>'0',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>250/$y);
    push @spawned_widgets,($r_on,$r_off);

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $tree->entryconfigure($treeitem,-text=>"$lbltext: $curval");
            LogIt("Changing $lbltext to $curval");
            my $ix_into_gff=(split /__/,$treeitem)[1];
            my $bitstring
               =unpack('B*',$$gbl_gff_ref->{Main}{Fields}[$$gbl_gff_ref->{Main}->get_field_ix_by_label('ValBoolean')]{Value});
            substr($bitstring,$ix_into_gff,1)=$curval;
            $$gbl_gff_ref->{Main}{Fields}[$$gbl_gff_ref->{Main}->get_field_ix_by_label('ValBoolean')]{Value}
               =pack('B*',$bitstring);
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",
        -command=>sub {
        CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}
#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnNumericWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$gbl_gff_ref)=@_;

    my $treetext=$tree->entrycget($treeitem,-text);
    $treetext =~ /(.*): (.*)/;
    my $lbltext=$1; my $curval=$2;
    my $lbl=$mw->Label(-text=>"Global Numeric: $lbltext",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $txt1=$mw->Entry(-textvariable=>\$curval,-background=>'white',-width=>9)->place(-relx=>770/$x,-rely=>200/$y);
    push @spawned_widgets,$txt1;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $tree->entryconfigure($treeitem,-text=>"$lbltext: $curval");
            LogIt("Changing $lbltext to $curval");
            my $ix_into_gff=(split /__/,$treeitem)[1];
            my @bytevalues
               =unpack('C*',$$gbl_gff_ref->{Main}{Fields}[$$gbl_gff_ref->{Main}->get_field_ix_by_label('ValNumber')]{Value});
            $bytevalues[$ix_into_gff]=$curval;
            $$gbl_gff_ref->{Main}{Fields}[$$gbl_gff_ref->{Main}->get_field_ix_by_label('ValNumber')]{Value}
               =pack('C*',@bytevalues);
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",
        -command=>sub {
        CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnGenderWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$curgendertext,$ifo_gff_ref)=@_;
    my %revgenders=reverse %genders;
    my $curgender=$revgenders{$curgendertext};

    if ($treeitem=~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl=$mw->Label(-text=>"Gender: $curgendertext",-font=>['MS Sans Serif','8'])->place(-relx=>690/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;


    my $gender_male=$mw->Radiobutton(-text=>"Male",-variable=>\$curgender,-value=>'0',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>220/$y);
    my $gender_female=$mw->Radiobutton(-text=>"Female",-variable=>\$curgender,-value=>'1',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>250/$y);
    my $gender_both=$mw->Radiobutton(-text=>"Both",-variable=>\$curgender,-value=>'2',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>280/$y);
    my $gender_other=$mw->Radiobutton(-text=>"Other",-variable=>\$curgender,-value=>'3',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>310/$y);
    my $gender_none=$mw->Radiobutton(-text=>"None",-variable=>\$curgender,-value=>'4',-activeforeground=>"blue")->place(-relx=>700/$x,-rely=>340/$y);
    push @spawned_widgets,($gender_male,$gender_female,$gender_both,$gender_other,$gender_none);

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            $curgendertext=$genders{$curgender};
            $tree->entryconfigure($treeitem,-text=>"Gender: $curgendertext");
            LogIt("Changing Gender to $curgendertext");
            if ($treeitem =~/NPCs/) {
                $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Gender')]{Value}=$curgender;
                my $root='#'.(split /#/,$treeitem)[1];                        #store the new
                my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
                $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
                my $temp=$1;
                my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
            } else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                $mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('Gender')]{Value}=$curgender; }
                         })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",
        -command=>sub {
        CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnChangeClassWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$ifo_gff_ref)=@_;
    my $cur_class=$tree->entrycget($treeitem,-text);
    my %revhash=reverse %classes;
    my $class_struct_index=$treeitem;
    $class_struct_index=chop $class_struct_index;    #note, this is inherently flawed
                                                     #because a user could add a class, add another,
                                                     #then delete the first one and now the indices
                                                     #will be off
    if ($treeitem=~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>30/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl1=$mw->Label(-text=>"Selected Class: $cur_class",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>75/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl1;

    my $lbl=$mw->Label(-text=>"Available Classes:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>100/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $classlist= $mw->Scrolled('Listbox',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#009000'
    )->place(-relx=>600/$x,-rely=>100/$y,-relwidth=>270/$x,-relheight=>200/$y);

    $classlist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $classlist;

    my $btn1=$mw->Button(-text=>'Change Class',-command=>sub {
        my $cur_list_index=$classlist->curselection;
        if ($cur_list_index eq '' ) { return; } #nothing selected
        my $newclassvalue=$revhash{$classlist->get($cur_list_index)};
        my $oldclassvalue=$revhash{($tree->entrycget($treeitem,-text))};
        LogIt ("Changing class from " .($tree->entrycget($treeitem,-text)). " ($oldclassvalue) to " .
               $classlist->get($cur_list_index) . " ($newclassvalue)");

        #get the struct in question

        my $class_struct;
        my $mod_playerlist;
        if ($treeitem=~/NPCs/) {
            $class_struct=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{Value}[$class_struct_index];
        } else {
            $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            $class_struct=$mod_playerlist->{Fields}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value}[$class_struct_index];
        }

        #change the class

        $class_struct->{Fields}[$class_struct->get_field_ix_by_label('Class')]{Value}=$newclassvalue;

        #handle non-jedi -> jedi change

        if ( (($newclassvalue>2) && ($newclassvalue<6)) &&    #new class is a spell caster
                (($oldclassvalue<3) || ($oldclassvalue>5)) ){ #old class was not -- need to configure
            LogIt('Adding power list');
            my $sub_struct=Bioware::GFF::Struct->new('ID'=>17767);
            $sub_struct->createField('Type'=>FIELD_BYTE,'Label'=>'NumSpellsLeft','Value'=>0);
            $class_struct->createField('Type'=>FIELD_LIST,'Label'=>'SpellsPerDayList','Value'=>[$sub_struct]);
            $class_struct->createField('Type'=>FIELD_LIST,'Label'=>'KnownList0','Value'=>[]);
            $tree->add($treeitem."#KnownList0",-text=>'Force Powers',-data=>'can modify');
            $tree->hide('entry',$treeitem."#KnownList0");

        #handle jedi -> non-jedi change

        } elsif ( ( ($newclassvalue<3)||($newclassvalue>5) ) &&     #new class is not a spell caster
                ( ($oldclassvalue>2)&&($oldclassvalue<6) ) ) {    #but old class was -- need to configure
            LogIt ('Removing power list');
            my $ix=0;
            my @newfields=();
            for my $classfield (@{$class_struct->{Fields}}) {
                unless ( ($ix=$class_struct->get_field_ix_by_label('KnownList0')) ||
                         ($ix=$class_struct->get_field_ix_by_label('SpellsPerDayList')) ) {
                    push @newfields,$classfield;
                }
                $ix++;
            }
            $class_struct->{Fields}=[@newfields];
            if ($tree->info('exists',$treeitem.'#KnownList0')) {
                $tree->delete('offsprings',$treeitem.'#KnownList0');
                $tree->delete('entry',$treeitem.'#KnownList0');
            }
        }
        $tree->autosetmode();
        $tree->entryconfigure($treeitem,-text=>($classlist->get($cur_list_index)));
        if ($treeitem=~/NPCs/) {
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);
        }
    }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>90/$x);

    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;


    my $btn3=$mw->Button(-text=>"Add Class",-command=>sub {


            my $cur_list_index=$classlist->curselection;
            if ($cur_list_index eq '' ) { return; } #nothing selected
            my $newclassvalue=$revhash{$classlist->get($cur_list_index)};

            #get a reference to the current ClassList
            my $class_struct_array_ref;
            if ($treeitem=~/NPCs/) {
                $class_struct_array_ref=$$ifo_gff_ref->{Main}{'Fields'}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{'Value'};
            } else {
                my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
                $class_struct_array_ref=$mod_playerlist->{'Fields'}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value};
            }

            #Create another class struct
            my $new_class_struct=Bioware::GFF::Struct->new('ID'=>2);
            $new_class_struct->createField('Type'=>FIELD_INT,'Label'=>'Class','Value'=>$newclassvalue);
            $new_class_struct->createField('Type'=>FIELD_SHORT,'Label'=>'ClassLevel','Value'=>1);

            #add spell casater fields to new struct if required
            if (($newclassvalue>2) && ($newclassvalue<6)) {
                my $sub_struct=Bioware::GFF::Struct->new('ID'=>17767);
                $sub_struct->createField('Type'=>FIELD_BYTE,'Label'=>'NumSpellsLeft','Value'=>0);
                $new_class_struct->createField('Type'=>FIELD_LIST,'Label'=>'SpellsPerDayList','Value'=>[$sub_struct]);
                $new_class_struct->createField('Type'=>FIELD_LIST,'Label'=>'KnownList0','Value'=>[]);
            }

            #Add new class struct to the ClassList
            push @$class_struct_array_ref,$new_class_struct;

            #Update the Tree
            $treeitem =~ /(.*)#Class(\d+)/;
            my $newtreeitem="$1#Class" .($2+1);
            $tree->add($newtreeitem,-text=>$classes{$newclassvalue},-data=>'can modify');
            $tree->add("$newtreeitem#Level",-text=>'Level: 1',-data=>'can modify');
            $tree->hide('entry',"$newtreeitem#Level");
            if (($newclassvalue>2) && ($newclassvalue<6)) { #spell caster fields req'd
                $tree->add("$newtreeitem#KnownList0",-text=>'Force Powers',-data=>'can modify');
                $tree->hide('entry',"$newtreeitem#KnownList0");
            }

            #store .utc if necessary
            if ($treeitem=~/NPCs/) {
                my $root='#'.(split /#/,$treeitem)[1];
                my $datahash=$tree->entrycget($root,-data);
                $treeitem =~/NPCs#(.*?)#/;
                my $temp=$1;
                my $npcnum=chop $temp;
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
            }

            #done
            $tree->autosetmode();
    })->place(-relx=>600/$x,-rely=>350/$y,-relwidth=>90/$x);
    push @spawned_widgets,$btn3;

    my $btn4=$mw->Button(-text=>"Remove Class",-command=>sub {

        #get a reference to the current ClassList
        my $class_struct_array_ref;
        if ($treeitem=~/NPCs/) {
            $class_struct_array_ref=$$ifo_gff_ref->{Main}{'Fields'}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('ClassList')]{'Value'};
        } else {
            my $mod_playerlist=$$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList')]{Value}[0];
            $class_struct_array_ref=$mod_playerlist->{'Fields'}[$mod_playerlist->get_field_ix_by_label('ClassList')]{Value};
        }
        my $classtext=$tree->entrycget($treeitem,-text);
        my $classval=$revhash{$classtext};
        my @new_class_struct_array;

        #create a new ClassList that does not include the struct marked for removal
        for my $class_struct (@$class_struct_array_ref) {
            unless ( $class_struct->{'Fields'}[$class_struct->get_field_ix_by_label('Class')]{'Value'} == $classval ) {
                push @new_class_struct_array,$class_struct
            }
        }

        #write the new ClassList to the GFF
        $$class_struct_array_ref=[@new_class_struct_array];

        #store the .utc if necessary
        if ($treeitem=~/NPCs/) { #seal the deal
            my $root='#'.(split /#/,$treeitem)[1];
            my $datahash=$tree->entrycget($root,-data);
            $treeitem =~/NPCs#(.*?)#/;
            my $temp=$1;
            my $npcnum=chop $temp;
            $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
            $tree->entryconfigure($root,-data=>$datahash);
        }

        $tree->delete('offsprings',$treeitem);
        $tree->delete('entry',$treeitem);

    })->place(-relx=>600/$x,-rely=>450/$y,-relwidth=>90/$x);
    push @spawned_widgets,$btn4;
}
#>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnAppearanceWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$ifo_gff_ref)=@_;
    my $cur_appearance=$tree->entrycget($treeitem,-text);
    my $cur_appearance_name=(split /: /,$cur_appearance)[1];
    my %revhash=reverse %appearance_hash;

    if ($treeitem=~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl1=$mw->Label(-text=>"Current $cur_appearance",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>95/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl1;

    my $lbl=$mw->Label(-text=>"Available Appearances:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>120/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $appearancelist= $mw->Scrolled('Listbox',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#009000'
    )->place(-relx=>600/$x,-rely=>120/$y,-relwidth=>270/$x,-relheight=>380/$y);

    $appearancelist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $appearancelist;

    my $btn1=$mw->Button(-text=>'Change Appearance',-command=>sub {
        my $cur_list_index=$appearancelist->curselection;
        if ($cur_list_index eq '' ) { return; } #nothing selected
        my $newappearancevalue=$revhash{$appearancelist->get($cur_list_index)};
        my $oldappearancevalue=$revhash{$cur_appearance_name};
        LogIt ("Changing appearance from $cur_appearance_name  ($oldappearancevalue) to " .
               $appearancelist->get($cur_list_index) . " ($newappearancevalue)");
        $tree->autosetmode();
        $tree->entryconfigure($treeitem,-text=>"Appearance: " . ($appearancelist->get($cur_list_index)));
        if ($treeitem=~/NPCs/) {
            $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('Appearance_Type')]{Value}=$newappearancevalue;
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
        } else {
            my $mplix=$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList');
            $$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]{Fields}[$$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]->get_field_ix_by_label('Appearance_Type')]{'Value'}=$newappearancevalue;
        }
    }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>120/$x);

    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;


}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnPortraitWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$ifo_gff_ref)=@_;
    my $cur_portrait=$tree->entrycget($treeitem,-text);
    my $cur_portrait_name=(split /: /, $cur_portrait)[1];
    my %revhash=reverse %portraits_hash;

    if ($treeitem=~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl1=$mw->Label(-text=>"Current $cur_portrait",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>95/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl1;

    my $lbl=$mw->Label(-text=>"Available Portraits:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>120/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $portraitlist= $mw->Scrolled('Listbox',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#009000'
    )->place(-relx=>600/$x,-rely=>120/$y,-relwidth=>270/$x,-relheight=>380/$y);

    $portraitlist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $portraitlist;

    my $btn1=$mw->Button(-text=>'Change Portrait',-command=>sub {
        my $cur_list_index=$portraitlist->curselection;
        if ($cur_list_index eq '' ) { return; } #nothing selected
        my $newportraitvalue=$revhash{$portraitlist->get($cur_list_index)};
        my $oldportraitvalue=$revhash{$cur_portrait_name};
        LogIt ("Changing appearance from $cur_portrait_name ($oldportraitvalue) to " .
               $portraitlist->get($cur_list_index) . " ($newportraitvalue)");
        $tree->autosetmode();
        $tree->entryconfigure($treeitem,-text=>"Portrait: " . ($portraitlist->get($cur_list_index)));
        if ($treeitem=~/NPCs/) {
            $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('PortraitId')]{Value}=$newportraitvalue;
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
        } else {
            my $mplix=$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList');
            $$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]{Fields}[$$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]->get_field_ix_by_label('PortraitId')]{'Value'}=$newportraitvalue;
        }
    }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>120/$x);

    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;

}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnSoundsetWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>

    my ($treeitem,$ifo_gff_ref)=@_;
    my $cur_soundset=$tree->entrycget($treeitem,-text);
    my $cur_soundset_name=(split /: /, $cur_soundset)[1];
    my %revhash=reverse %soundset_hash;

    if ($treeitem=~/NPCs/) {
        $treeitem=~/(.*#NPCs#.*?)#/;
        my $npcname=$tree->entrycget($1,-text);
        my $lbl_npc=$mw->Label(-text=>"-- $npcname --",-font=>['MS Sans Serif','8'])->place(-relx=>610/$x,-rely=>50/$y,-anchor=>'nw');
        push @spawned_widgets,$lbl_npc;
    }

    my $lbl1=$mw->Label(-text=>"Current $cur_soundset",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>95/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl1;

    my $lbl=$mw->Label(-text=>"Available soundsets:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>120/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    my $soundsetlist= $mw->Scrolled('Listbox',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#009000'
    )->place(-relx=>600/$x,-rely=>120/$y,-relwidth=>270/$x,-relheight=>380/$y);

    $soundsetlist->insert('end',(sort keys %revhash));
    push @spawned_widgets, $soundsetlist;

    my $btn1=$mw->Button(-text=>'Change soundset',-command=>sub {
        my $cur_list_index=$soundsetlist->curselection;
        if ($cur_list_index eq '' ) { return; } #nothing selected
        my $newsoundsetvalue=$revhash{$soundsetlist->get($cur_list_index)};
        my $oldsoundsetvalue=$revhash{$cur_soundset_name};
        LogIt ("Changing soundset from $cur_soundset_name ($oldsoundsetvalue) to " .
               $soundsetlist->get($cur_list_index) . " ($newsoundsetvalue)");
        $tree->autosetmode();
        $tree->entryconfigure($treeitem,-text=>"Soundset: " . ($soundsetlist->get($cur_list_index)));
        if ($treeitem=~/NPCs/) {
            $$ifo_gff_ref->{Main}{Fields}[$$ifo_gff_ref->{Main}->get_field_ix_by_label('SoundSetFile')]{Value}=$newsoundsetvalue;
            my $root='#'.(split /#/,$treeitem)[1];                        #store the new
            my $datahash=$tree->entrycget($root,-data);                   #gff in the root's datahash
            $treeitem =~/NPCs#(.*?)#/;                                    #so we know that it needs replacing
            my $temp=$1;
            my $npcnum=chop $temp;                                        #when it comes time to commit changes
                $datahash->{"AVAILNPC$npcnum.utc"}=$$ifo_gff_ref;
                $tree->entryconfigure($root,-data=>$datahash);
        } else {
            my $mplix=$$ifo_gff_ref->{Main}->get_field_ix_by_label('Mod_PlayerList');
            $$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]{Fields}[$$ifo_gff_ref->{Main}{'Fields'}[$mplix]{Value}[0]->get_field_ix_by_label('SoundSetFile')]{'Value'}=$newsoundsetvalue;
        }
    }
    )->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>120/$x);

    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;

}



#>>>>>>>>>>>>>>>>>>>>>>>
sub Populate_Inventory {
#>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem)=shift;
    LogIt("Populating $treeitem");
    my $gff=${$tree->entrycget( '#'.(split /#/,$treeitem)[1],-data)}{'GFF-inv'};
    my $itemlist=$gff->{Main}{Fields}{Value};
    my @items;
    for my $item_struct (@$itemlist) {
        my $strref=$item_struct->{Fields}[$item_struct->get_field_ix_by_label('LocalizedName')]{Value}{StringRef};
        my $item_name;
        if ($strref==-1) {
            $item_name=$item_struct->{Fields}[$item_struct->get_field_ix_by_label('LocalizedName')]{Value}{Substrings}[0]{Value}; }
        else {
            $item_name=Bioware::TLK::string_from_resref($registered_path,$strref);
        }
        my $tag=lc $item_struct->{Fields}[$item_struct->get_field_ix_by_label('Tag')]{Value};
        my $stack=$item_struct->{Fields}[$item_struct->get_field_ix_by_label('StackSize')]{Value};
        my $pretty_item=sprintf("%-32s%s  [%d]",$tag,$item_name,$stack);
        push @items,$pretty_item;
    }
    my $i=0;
    for my $item (sort @items) {
        my $tag=(split / /,$item)[0];
        $tree->add($treeitem."#$tag"."__$i",-text=>$item,-data=>'can modify');#-font=>['Courier New','8']);
        $i++;
    }
    $tree->entryconfigure($treeitem,-data=>'can modify');
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnInventoryWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>
    my ($treeitem,$inv_gff_ref)=@_;
    my $curtext=$tree->entrycget($treeitem,-text);
    $curtext=~/(.*)\[(\d+)/;

    my $lbl1=$mw->Label(-text=>$1,-font=>['MS Sans Serif','8'])->place(-relx=>650/$x,-rely=>200/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl1;

    my $lbl2=$mw->Label(-text=>'# In Inventory:',-font=>['MS Sans Serif','10'])->place(-relx=>650/$x,-rely=>230/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl2;

    my $lbl_count=$mw->Label(-text=>$2,-font=>['MS Sans Serif','10'],-bg=>'#FFFFFF')->place(-relx=>750/$x,-rely=>230/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl_count;

    my $btn_sub=$mw->Button(-text=>"-",-font=>['MS Sans Serif','10'],-command=>sub{
        my $cur_val=$lbl_count->cget(-text);
        if ($cur_val > 0) {
            $cur_val--;
            $lbl_count->configure(-text=>$cur_val);
        }
    })->place(-relx=>700/$x,-rely=>260/$y,-anchor=>'sw',-relwidth=>50/$x);
    push @spawned_widgets,$btn_sub;

    my $btn_add=$mw->Button(-text=>"+",-font=>['MS Sans Serif','10'],-command=>sub{
        my $cur_val=$lbl_count->cget(-text);
        $cur_val++;
        $lbl_count->configure(-text=>$cur_val);
    })->place(-relx=>750/$x,-rely=>260/$y,-anchor=>'sw',-relwidth=>50/$x);
    push @spawned_widgets,$btn_add;

    my $btn1=$mw->Button(-text=>'Apply',-command=>sub {
            my $cur_val=$lbl_count->cget('-text');
            my $curtext=$tree->entrycget($treeitem,-text);
            if ($cur_val>0) {
                $curtext=~/(.*)\[(\d+)/;
                LogIt ("Changing count of $1 from $2 to $cur_val");
                my $newtext="$1\[$cur_val\]";
                my $this_tag=(split / /,$curtext)[0];
                $tree->entryconfigure($treeitem,-text=>$newtext);
                my $itemlist=$$inv_gff_ref->{Main}{Fields}{Value};
                for my $item_struct (@$itemlist) {
                    my $tag=lc $item_struct->{Fields}[$item_struct->get_field_ix_by_label('Tag')]{Value};
                    if ($tag eq $this_tag) {
                        $item_struct->{Fields}[$item_struct->get_field_ix_by_label('StackSize')]{Value}=$cur_val;
                        last;
                    }
                }
            } else {
                my $this_tag=(split / /,$curtext)[0];
                LogIt("Removing $this_tag from inventory");
                my $itemlist=$$inv_gff_ref->{Main}{Fields}{Value};
                my @newitemlist;
                for my $item_struct (@$itemlist) {
                    my $tag=lc $item_struct->{Fields}[$item_struct->get_field_ix_by_label('Tag')]{Value};
                    unless ($tag eq $this_tag) {
                        push @newitemlist, $item_struct;
                    }
                }
                $$inv_gff_ref->{Main}{Fields}{Value}=[@newitemlist];
                $tree->delete('entry',$treeitem);
            }
            })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>60/$x);
    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",
        -command=>sub {
        CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne');
    push @spawned_widgets,$btn2;
}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub SpawnAddInventoryWidgets {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
my ($treeitem,$inv_gff_ref)=@_;

    my $lbl=$mw->Label(-text=>"Available Items:",-font=>['MS Sans Serif','8'])->place(-relx=>600/$x,-rely=>120/$y,-anchor=>'sw');
    push @spawned_widgets,$lbl;

    if (scalar keys %master_item_list == 0) {
        $lbl->configure(-text=>"Building Master Item List...");
        Generate_Master_Item_List();
        $lbl->configure(-text=>"Available Items:");
    }



    my @templates;
    my @treeitem_children=$tree->info('children',$treeitem);
    my %possessed;
    for my $treeitem_child (@treeitem_children) {
        $treeitem_child =~ /Inventory#(.*)__/;
        $possessed{$1}=1;
    }

    for my $key (sort keys %master_item_list) {
        my $desc=$master_item_list{$key}{'desc'};
        $desc=~s/\n/ /g;    #get rid of any new line chars
        my $lilhash={'itemtext'=>sprintf("%-18s%-18s%s",$key,$master_item_list{$key}{'tag'},$desc),
                     'override'=>$master_item_list{$key}{'override'},
                     'possessed'=>$possessed{$master_item_list{$key}{'tag'}}
                    };
         if ($lilhash->{'override'}) { LogIt "override: itemtext: $$lilhash{'itemtext'} ### $key # $master_item_list{$key}{'tag'} # $desc" }

        push @templates,$lilhash;
    }



    my $templatelist= $mw->Scrolled('TList',
                                 -scrollbars=>'osoe',
                                 -background=>'white',
                                 -selectborderwidth=>'0',
                                 -selectforeground=>'#FFFFFF',
                                 -selectbackground=>'#B0B0B0',
                                 -selectmode=>'extended',
                                 -itemtype=>'text',
                                 -font=>['Lucida Console','8'],
                                 -orient=>'horizontal',
                                 -pady=>0

    )->place(-relx=>600/$x,-rely=>120/$y,-relwidth=>270/$x,-relheight=>380/$y);

    my $overridestyle = $mw->ItemStyle('text',
                                  -foreground=>'#FF4040',
                                  -selectforeground=>'#A00000',
                                  -selectbackground=>'#B0B0B0',
                                  -font=>['Lucida Console','8']);
    my $pstylefg='#4040FF';
    my $possessedstyle = $mw->ItemStyle('text',
                                  -foreground=>$pstylefg,
                                  -selectforeground=>'#0000A0',
                                  -selectbackground=>'#B0B0B0',
                                  -font=>['Lucida Console','8']);
    my $underlinedstyle=$mw->ItemStyle('text',-font=>['Lucida Console','8','underline']);

    $templatelist->insert('end',-text=>sprintf("%-18s%-18s%s","TemplateResRef","Tag","Description"),-style=>$underlinedstyle);
    for my $template (@templates) {
        if ($template->{'possessed'})  {
            $templatelist->insert('end',-text=>$template->{'itemtext'},-style=>$possessedstyle); }
        elsif ($template->{'override'}) {
            for (my $i=0; $i<length $template->{'itemtext'}; $i++){
                #LogIt (substr ($template->{'itemtext'},$i) . ' ' . ord (substr ($template->{'itemtext'},$i)));
            }
            $templatelist->insert('end',-text=>$template->{'itemtext'},-style=>$overridestyle); }
        else {
            $templatelist->insert('end',-text=>$template->{'itemtext'});
        }
    }
    push @spawned_widgets, $templatelist;

   my $btn1=$mw->Button(-text=>'Add Items',-command=>sub{
        my @selected_indices=$templatelist->info('selection');
        return unless (scalar @selected_indices); #nothing selected
        for my $selected_index (@selected_indices) {
            next if $selected_index==0;
            my $thisstyle=$templatelist->entrycget($selected_index,-style);   #check the style
            if ($thisstyle) {                                                 # to see if it is already possessed
                if ($thisstyle->cget(-foreground) eq $pstylefg) { next }
            }
            my $this_item_text=$templatelist->entrycget($selected_index,-text);
            LogIt("Adding Item: $this_item_text");
            my $selected_uti=(split / /,$this_item_text)[0] . ".uti";
            my $uti_gff=Bioware::GFF->new();
            if (-e "$registered_path\\override\\$selected_uti") {
                $uti_gff->read_gff_file("$registered_path\\override\\$selected_uti"); }
            else {
                my $bif=Bioware::BIF->new(undef,23,'uti');
                my $resource_ref=$bif->get_resource('data\\templates.bif',$selected_uti);
                $uti_gff->read_gff_scalar($resource_ref);
            }



            #create new struct in inventory item list based on uti fields

            my $itemlist_struct=Bioware::GFF::Struct->new('ID'=>0);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('BaseItem')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Tag')]);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'Identified','Value'=>1);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Description')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('DescIdentified')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('LocalizedName')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('StackSize')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Stolen')]);
            $itemlist_struct->createField('Type'=>FIELD_DWORD,'Label'=>'Upgrades','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'Dropable','Value'=>1);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'Pickpocketable','Value'=>1);
            if (defined ($uti_gff->{Main}->get_field_ix_by_label('ModelVariation'))) {
                push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('ModelVariation')]);
            } else {
                $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'ModelVariation','Value'=>1);
            }
            #if (defined ($uti_gff->{Main}->get_field_ix_by_label('BodyVariation'))) {
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('BodyVariation')]);
            #}
            #if (defined ($uti_gff->{Main}->get_field_ix_by_label('TextureVar'))) {
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('TextureVar')]);
            #}

            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Charges')]);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'MaxCharges','Value'=>($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Charges')]{Value}));
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Cost')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('AddCost')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Plot')]);
            push @{$itemlist_struct->{Fields}},($uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('PropertiesList')]);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'XPosition','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'YPosition','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'ZPosition','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'XOrientation','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'YOrientation','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_FLOAT,'Label'=>'ZOrientation','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'NonEquippable','Value'=>0);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'NewItem','Value'=>1);
            $itemlist_struct->createField('Type'=>FIELD_BYTE,'Label'=>'DELETING','Value'=>0);

            push @{$$inv_gff_ref->{Main}{Fields}{Value}}, $itemlist_struct;


        # update tree as per Populate Inventory sub
            my $last_child_ix=-1;
            for my $treeitem_child (@treeitem_children) {
                $treeitem_child=~/__(\d+)/;
                if ($1 > $last_child_ix) { $last_child_ix = $1 }
            }
            $last_child_ix++;
            my $strref=$itemlist_struct->{Fields}[$itemlist_struct->get_field_ix_by_label('LocalizedName')]{Value}{StringRef};
            my $item_name;
            if ($strref==-1) {
                $item_name=$itemlist_struct->{Fields}[$itemlist_struct->get_field_ix_by_label('LocalizedName')]{Value}{Substrings}[0]{Value}; }
            else {
                $item_name=Bioware::TLK::string_from_resref($registered_path,$strref);
            }
            my $tag=lc $uti_gff->{Main}{Fields}[$uti_gff->{Main}->get_field_ix_by_label('Tag')]{Value};  #make sure this is used so can be found in BIF
            my $stack=$itemlist_struct->{Fields}[$itemlist_struct->get_field_ix_by_label('StackSize')]{Value};
            my $pretty_item=sprintf("%-32s%s  [%d]",$tag,$item_name,$stack);
            $tree->add($treeitem."#$tag"."__$last_child_ix",-text=>$pretty_item,-data=>'can modify');

        # update style in list
            $templatelist->entryconfigure($selected_index,-style=>$possessedstyle);
            LogIt("Successful");
        }
   })->place(-relx=>600/$x,-rely=>520/$y,-relwidth=>90/$x);

    push @spawned_widgets,$btn1;

    my $btn2=$mw->Button(-text=>"Commit Changes",-command=>sub { CommitChanges($treeitem) })->place(-relx=>870/$x,-rely=>520/$y,-anchor=>'ne',-relwidth=>90/$x);
    push @spawned_widgets,$btn2;

}

#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
sub Generate_Master_Item_List {
#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
    use IO::Scalar;
    $mw->Busy(-recurse=>1);

    # first get all uti files from templates.bif
    my $bif=Bioware::BIF->new(undef,23,'uti');
    my @templates=(sort keys %{$bif->{BIFs}{'data\\templates.bif'}{Resources}}) ;
    my $tmp_gff=Bioware::GFF->new();
    for my $template (@templates) {
        my $resource_ref=$bif->get_resource('data\\templates.bif',$template);
        $template =~ s/\.uti//;
        $tmp_gff->read_gff_scalar($resource_ref);
        $master_item_list{$template}{'tag'}=lc $tmp_gff->{Main}{Fields}[$tmp_gff->{Main}->get_field_ix_by_label('Tag')]{Value};
        my $locname=$tmp_gff->{Main}{Fields}[$tmp_gff->{Main}->get_field_ix_by_label('LocalizedName')]{Value};
        my $strref=$locname->{StringRef};
        if ($strref == -1) {
            $master_item_list{$template}{'desc'}=$locname->{Substrings}[0]{Value};
        } else {
            $master_item_list{$template}{'desc'}=Bioware::TLK::string_from_resref($registered_path,$strref);
        }
        $master_item_list{$template}{'override'}=0;
    }
    #idea -- how about using a TList instead of a Listbox and making any overriden
    #  items in a different color style... :-)

    #now get all uti files from override (overriding any templates.bif uti)
    chdir "$registered_path\\override";
    my @utifiles_in_override=glob "*.uti";
    for my $override_uti (@utifiles_in_override) {
        $tmp_gff->read_gff_file($override_uti);

        my $locname=$tmp_gff->{Main}{Fields}[$tmp_gff->{Main}->get_field_ix_by_label('LocalizedName')]{Value};
        my $strref=$locname->{StringRef};
        my $template=$tmp_gff->{Main}{Fields}[$tmp_gff->{Main}->get_field_ix_by_label('TemplateResRef')]{Value};
        $template=~/(\w+)/;
        $template=$1;
        my $tag=lc $tmp_gff->{Main}{Fields}[$tmp_gff->{Main}->get_field_ix_by_label('Tag')]{Value};
        $tag=~/(\w+)/;
        $tag=$1;
        $master_item_list{$template}{'tag'}=$tag;
        if ($strref == -1) {
            $master_item_list{$template}{'desc'}=$locname->{Substrings}[0]{Value};
        } else {
            $master_item_list{$template}{'desc'}=Bioware::TLK::string_from_resref($registered_path,$strref);
        }
        $master_item_list{$template}{'override'}=1;
    }
    $mw->Unbusy;
}

sub LogIt {
    unless ($debug_flag) {return;}
    my $loginfo=shift;
    my ($sec,$min,$hour,$mday,$mon,$year)=localtime;
    printf STDERR "%.2u-%.2u-%.4u %.2u:%.2u:%.2u %s\n",($mon+1,$mday,$year+1900,$hour,$min,$sec,$loginfo);
    return;
}

sub Tk::Error   #custom error handler --> error log, and error msg
{my $w = shift;
 my $error = shift;
 if (Exists($w))
  {
   my $grab = $w->grab('current');
   $grab->Unbusy if (defined $grab);
  }
 chomp($error);
 $mw->Dialog(-title=>'Error occurred',-text=>"Error msg: $error\n ",-font=>['MS Sans Serif','8'],-buttons=>['Ok'])->Show();
 $mw->Dialog(-title=>'Details of Error ',-text=> join("\n " , @_)."\n",-font=>['MS Sans Serif','8'],-buttons=>['Ok'])->Show();
 warn "Tk::Error: $error\n " . join("\n ",@_)."\n";  #writes to LogIt
}

sub RWhat {
    my $w=shift;
    my $ev = $w->XEvent();
    $tree->Button1($ev); # make sure to select the item
    $tree->ButtonRelease1($ev); # make sure to select the item
    my $treeitem=($tree->info('selection'))[0]; #get the item name selected

    # a little handwaving here to allow the user to right click on
    # either the treeroot or Inventory leaf and get same effect
    my $treeroot=$treeitem;
    if ($treeitem =~ /Inventory$/) {
        $treeroot = '#'.(split /#/,$treeitem)[1];
    }


    #check to make sure the root has been selected and already contains
    #the inventory gff (that is, Populate_Level1 has been called)

    my $datahash=$tree->entrycget($treeroot,-data);
    return unless (ref ($datahash) eq 'HASH');
    return unless (exists $$datahash{'GFF-inv'});

    #create Inventory Popup Menu
    my $inventoryMenu = $mw->Menu(
                             -tearoff  => 0);

    #Note: for some reason, the -command parameter of these menu buttons
    # has to be in the form of sub { function } rather than \&function
    # otherwise the function will be called immediately upon insert method... :-s

    $inventoryMenu->insert(0,
                           'command',
                           -label=>'Copy Inventory From This Savegame',
                           -command=>sub { CopyInventory($treeitem,$datahash) },
                           -state=>'normal');
    $inventoryMenu->insert(1,
                           'command',
                           -label=>'Paste Inventory Into This Savegame',
                           -command=>sub { PasteInventory($treeroot,$datahash) },
                           -state=>'disabled');
    if ($inventory_in_memory==1) {
        $inventoryMenu->entryconfigure(1,-state=>'normal');
    }
    #show popup at cursor
    $inventoryMenu->Popup(
    -popover  => 'cursor',
    -popanchor => 'nw');

}
sub CopyInventory {
    my ($treeitem_source,$datahash)=@_;

    #for later readability in dialog box...
    my $treeitem_desc=(split /#/,$treeitem_source)[1];
    my $res_gff=$datahash->{'GFF-res'};
    $inventory_source_savegame_name=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('SAVEGAMENAME')]{Value};

    #memorize inventory...
    $inventory_memorized=$datahash->{'GFF-inv'};


    #remove temp indicator from any earlier DItem
    if ($inventory_in_memory==1) {

        #earlier copy was in effect...
        my $current_tix_image_of_old_source_item=$tree->indicator('cget',$inventory_source_treeitem,'image');

        if ($current_tix_image_of_old_source_item eq 'image5') {

            #and we still have the old indicator in effect, so change it back
            my $oldimage;
            if ($old_tix_image eq 'image1') {
                $tree->close($inventory_source_treeitem);
            } elsif ($old_tix_image eq 'image2') {
                $tree->open($inventory_source_treeitem);
            }
            $tree->autosetmode();
        }
    }

    #remember the current indicator of DItem
    $old_tix_image=$tree->indicator('cget',$treeitem_source,'image');

    #set new temp indicator to DItem
    my $newimage=$mw->Getimage('srcfile');
    $tree->indicator('configure',$treeitem_source,'image',$newimage);

    #make note of the changes
    $inventory_in_memory=1;
    $inventory_source_treeitem=$treeitem_source;

    #tell user we're done
    my $ok=$mw->Dialog(-title=>'Inventory Copied to Memory',
                       -text=>"Inventory from $treeitem_desc\n '$inventory_source_savegame_name'\n has been copied into memory.",
                       -font=>['MS Sans Serif','8'],
                       -buttons=>['Ok'])->Show();
}
sub PasteInventory {
    my ($treeitem_destination,$datahash)=@_;

    my $treeitem_desc=(split /#/,$treeitem_destination)[1];
    my $treeitem_src_desc=(split /#/,$inventory_source_treeitem)[1];
    my $res_gff=$datahash->{'GFF-res'};
    my $inventory_destination_savegame_name=$res_gff->{Main}{Fields}[$res_gff->{Main}->get_field_ix_by_label('SAVEGAMENAME')]{Value};

    my $confirm=$mw->Dialog(-title=>'Confirm Inventory Paste',
                       -text=>"Are you sure you wish to Paste the Inventory from\n$treeitem_src_desc  '$inventory_source_savegame_name'\nto\n$treeitem_desc  '$inventory_destination_savegame_name'?",
                       -font=>['MS Sans Serif','8'],
                       -buttons=>['Yes','No'])->Show();
    if ($confirm eq 'Yes') {
        $datahash->{'GFF-inv'}=$inventory_memorized;
        $tree->entryconfigure($treeitem_destination,-data=>$datahash);
        CommitChanges($treeitem_destination);
        $tree->delete('offsprings',$treeitem_destination."#Inventory");
        $tree->add($treeitem_destination."#Inventory#");
        $tree->hide('entry',$treeitem_destination."#Inventory#");
        $tree->autosetmode();
    }

}
