/********************
  Force Choke Anyone
  by tk102
*********************/



int SWFP_HARMFUL;
int SWFP_PRIVATE_SAVE_TYPE;
int SWFP_DAMAGE;
int SWFP_DAMAGE_TYPE;
int SWFP_DAMAGE_VFX;
int SWFP_PRIVATE_SAVE_VERSUS_TYPE;

int Sp_MySavingThrows(object oTarget);
int Sp_BlockingChecks(object oTarget, effect eEffect1, effect eEffect2, effect eDamage);
void SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget);
//--------------------
void main(){
//--------------------
    SWFP_HARMFUL = TRUE;
    SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;
    SWFP_DAMAGE = (GetHitDice(OBJECT_SELF)*2)/3;
    SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;
    SWFP_DAMAGE_VFX = VFX_IMP_CHOKE;

    effect eLink1 = EffectAbilityDecrease(ABILITY_CONSTITUTION, 4);
    eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_STRENGTH, 4));
    eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_DEXTERITY, 4));
    eLink1 = SetEffectIcon(eLink1, 3);

    effect eChoke = EffectChoke();
    effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);
    effect eInvalid;

     
    object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 17.0, GetLocation(OBJECT_SELF), TRUE, OBJECT_TYPE_CREATURE);
    while (GetIsObjectValid(oTarget)) {
        if (!GetIsFriend(oTarget) && !GetIsDead(oTarget)) {	break;}
        oTarget = GetNextObjectInShape(SHAPE_SPHERE, 17.0, GetLocation(OBJECT_SELF), TRUE, OBJECT_TYPE_CREATURE);
    }
    if (GetIsObjectValid(oTarget)) {
        int nResist = Sp_BlockingChecks(oTarget, eChoke, eDamage, eInvalid);
        int nSaves;
        if(nResist == 0)
        {
            nSaves = Sp_MySavingThrows(oTarget);
            if(nSaves == 0)
            {
                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_CHOKE), oTarget);
                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);
                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 24.0);
                int nIdx = 1;
                float fDelay;
                SP_InterativeDamage(eDamage, 7, oTarget);
            }
        }
        if(nResist > 0 || nSaves > 0)
        {
            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);
        }
    }
    return ; 
}


//--------------------------------------
int Sp_MySavingThrows(object oTarget)
//--------------------------------------
{
    int nSave;
    if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_FORT)
    {
        nSave = FortitudeSave(oTarget, GetSpellSaveDC(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);
    }
    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_REFLEX)
    {
        nSave = ReflexSave(oTarget, GetSpellSaveDC(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);
    }
    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_WILL)
    {
        nSave = WillSave(oTarget, GetSpellSaveDC(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);
    }
    if(nSave > 0)
    {
        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);
        DisplayFeedBackText(oTarget, 2);
    }
    return nSave;
}


//-----------------------------------------
int Sp_BlockingChecks(object oTarget, effect eEffect1, effect eEffect2, effect eDamage)
//-----------------------------------------
{
    int nReturn = FALSE;
    if(GetIsLinkImmune(oTarget, eEffect1) || GetIsLinkImmune(oTarget, eEffect2) || GetIsLinkImmune(oTarget, eDamage))
    {
        DisplayFeedBackText(oTarget, 1);
        nReturn = TRUE;
    }
    if(ResistForce(OBJECT_SELF, oTarget))
    {
        DisplayFeedBackText(oTarget, 0);
        nReturn = TRUE;
    }

    if(nReturn == TRUE)
    {
        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);
    }

    return nReturn;
}

//-----------------------------------------
void SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget)
//-----------------------------------------
{
    if(GetIsObjectValid(oTarget))
    {
        if(!GetIsConversationActive() && !GetIsDead(oTarget) && !GetIsFriend(oTarget))
        {
             if (nSecondsRemaining % 2 == 0)
             {
                  ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);
             }
             --nSecondsRemaining;
             if (nSecondsRemaining > 0)
             {
                DelayCommand(1.0f, SP_InterativeDamage(eDamage, nSecondsRemaining, oTarget));
             }
        }
    }
}
